/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Sami Rämö - sami.ramo@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include <QtTest/QtTest>

#include "map/mapcommon.h"
#include "map/gpslocationitem.h"

class TestGPSLocationItem: public QObject
{
    Q_OBJECT

private slots:
    void constructor();
    void enable();
    void position();
};

void TestGPSLocationItem::constructor()
{
    QPixmap accurate(":/res/images/gps_pos_accurate.png");

    GPSLocationItem item;

    // pixmap should not be set
    QVERIFY(item.pixmap().isNull());

    // position should be UNDEFINED
    QCOMPARE(item.pos(), QPointF(UNDEFINED, UNDEFINED));

    // zValue should be set
    QCOMPARE(item.zValue(), static_cast<qreal>(OWN_LOCATION_ICON_Z_LEVEL));

    // icon offset should be set based on accurate pixmap
    QCOMPARE(item.offset(), QPointF(-accurate.width() / 2, -accurate.height() / 2));

    // ItemIgnoresTransformations flag should be set
    QVERIFY(item.flags() & QGraphicsItem::ItemIgnoresTransformations);
}

void TestGPSLocationItem::enable()
{
    // create item and update it's position so pixmap is set
    GPSLocationItem item;
    item.updatePosition(QPoint(100, 100), 10);

    // item should be visible and pixmap set
    QCOMPARE(item.isVisible(), true);
    QCOMPARE(item.pixmap().isNull(), false);

    item.setEnabled(false);

    // item should be hidden and pixmap unset
    QCOMPARE(item.isVisible(), false);
    QCOMPARE(item.pixmap().isNull(), true);

    item.setEnabled(true);

    // item should be visible, but pixmap still unset until first position update is received
    QCOMPARE(item.isVisible(), true);
    QCOMPARE(item.pixmap().isNull(), true);

    item.updatePosition(QPoint(500, 500), 10);

    // pixmam should be set after first position update
    QCOMPARE(item.pixmap().isNull(), false);
}

void TestGPSLocationItem::position()
{
    GPSLocationItem item;
    item.updatePosition(QPoint(123, 321), 10);

    QCOMPARE(item.pos(), QPointF(123, 321));
}

QTEST_MAIN(TestGPSLocationItem)

#include "testgpslocationitem.moc"
