/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Kaj Wallin - kaj.wallin@ixonos.com
        Pekka Nissinen - pekka.nissinen@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef PANELSLIDERBAR_H
#define PANELSLIDERBAR_H

#include <QMouseEvent>
#include <QPaintEvent>
#include <QPixmap>
#include <QRect>
#include <QWidget>

#include "panelcommon.h"

/**
 * @brief Generic class for panel slider bars
 *
 * @author Kaj Wallin - kaj.wallin (at) ixonos.com
 * @author Pekka Nissinen - pekka.nissinen@ixonos.com
 *
 * @class PanelSliderBar panelsliderbar.h "ui/panelsliderbar.h"
 */
class PanelSliderBar : public QWidget
{
    Q_OBJECT

public:
    /**
     * @brief Constructor
     *
     * @param parent Parent
     * @param side Qstring for the sliderbar location. Accepts "LEFT" and "RIGHT"
     */
    PanelSliderBar(QWidget *parent, Side side);

    /**
     * @brief Enumerator for the slider bar state
     * Defines values: Open, Closed
     *
     * @sa changeDirection
     */
    enum SliderBarState {Open, Closed};

/*******************************************************************************
 * BASE CLASS INHERITED AND REIMPLEMENTED MEMBER FUNCTIONS
 ******************************************************************************/
protected:
    /**
     * @brief Draws the slider
     *
     * @param * QPaintEvent unused
     */
    void paintEvent(QPaintEvent *);

    /**
     * @brief Mouse release event used to expand/collapse the panel
     *
     * @param * Event
     *
     * @sa clicked
     */
    void mouseReleaseEvent(QMouseEvent *);

/*******************************************************************************
 * MEMBER FUNCTIONS AND SLOTS
 ******************************************************************************/
public slots:
    /**
     * @brief Slot to change sliderbar direction
     *
     * @param state Current state of the panel
     */
    void changeDirection(SliderBarState state);

    /**
     * @brief Slot to redraw the slider bar after window resize event
     *
     * @param size Size of the new window
     */
    void resizeSliderBar(const QSize &size);

/*******************************************************************************
 * SIGNALS
 ******************************************************************************/
signals:
    /**
     * @brief Signal that is emitted the slider bar is clicked
     *
     * @sa mouseReleaseEvent
     */
    void clicked();

/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/
private:
    int m_sliderDirection;              ///< Direction of the slider bar

    QPixmap m_menuDropShadowTile;       ///< Pixmap for menu drop shadow
    QPixmap m_sliderButton;             ///< Pixmap for panel sliding bar button
    QPixmap m_sliderButtonArrows[2];    ///< Pixmap array for panel sliding bar button arrows
    QPixmap m_sliderTile;               ///< Pixmap for panel sliding bar
    QRect m_bottomRect;                 ///< Rect for slider bar bottom
    QRect m_buttonRect;                 ///< Rect for slider bar button
    QRect m_topRect;                    ///< Rect for slider bar top
    QRegion m_sliderRegion;             ///< Region of the slider bar

    Side m_sliderSide;                  ///< Slider side
};
#endif // PANELSLIDERBAR_H
