/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Kaj Wallin - kaj.wallin@ixonos.com
        Pekka Nissinen - pekka.nissinen@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include <QDebug>
#include <QPainter>

#include "panelsidebar.h"

PanelSideBar::PanelSideBar(QWidget *parent, Side side)
    : QWidget(parent)
{
    qDebug() << __PRETTY_FUNCTION__;

    if (side == LEFT) {
        setObjectName("SidePanelLeft");
        m_panelTile.load(":res/images/side_bar_tile_left.png");
        m_panelMiddleTile.load(":res/images/side_bar_middle_left.png");
        move(0, PANEL_TOP_PADDING);
    } else if (side == RIGHT) {
        setObjectName("SidePanelRight");
        m_panelTile.load(":res/images/side_bar_tile_right.png");
        m_panelMiddleTile.load(":res/images/side_bar_middle_right.png");
        move(DEFAULT_SCREEN_WIDTH - SIDEBAR_WIDTH, PANEL_TOP_PADDING);
    } else {
        qFatal("Illegal PanelSideBar 2nd argument");
    }

    m_menuDropShadowTile.load(":res/images/menu_bar_drop_shadow.png");

    middleRect.setRect(0, (SIDEBAR_HEIGHT / 2) - (m_panelMiddleTile.height() / 2),
                             SIDEBAR_WIDTH, m_panelMiddleTile.height());
    topRect.setRect(0, 0, SIDEBAR_WIDTH, middleRect.top());
    bottomRect.setRect(0, middleRect.bottom() + 1, SIDEBAR_WIDTH,
                             SIDEBAR_HEIGHT - topRect.height() - middleRect.height());

    resize(SIDEBAR_WIDTH, SIDEBAR_HEIGHT);
    setAttribute(Qt::WA_TransparentForMouseEvents, true);
}

void PanelSideBar::paintEvent(QPaintEvent *)
{
    qDebug() << __PRETTY_FUNCTION__;

    QPainter painter(this);

    painter.drawTiledPixmap(topRect, m_panelTile);
    painter.drawPixmap(middleRect, m_panelMiddleTile);
    painter.drawTiledPixmap(bottomRect, m_panelTile);
    painter.drawTiledPixmap(0, 0, SIDEBAR_WIDTH, m_menuDropShadowTile.height(), m_menuDropShadowTile);
}

void PanelSideBar::resizeSideBar(const QSize &size)
{
    qDebug() << __PRETTY_FUNCTION__;

    if (objectName() == "SidePanelRight")
        move(size.width() - SIDEBAR_WIDTH, PANEL_TOP_PADDING);

    middleRect.setRect(0, (size.height() / 2) - (m_panelMiddleTile.height() / 2),
                             SIDEBAR_WIDTH, m_panelMiddleTile.height());
    topRect.setRect(0, 0, SIDEBAR_WIDTH, middleRect.top());
    bottomRect.setRect(0, middleRect.bottom() + 1,
                       SIDEBAR_WIDTH, size.height() - topRect.height() - middleRect.height());

    resize(SIDEBAR_WIDTH, size.height() - PANEL_TOP_PADDING - PANEL_BOTTOM_PADDING);
}
