 /*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Kaj Wallin - kaj.wallin@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
 */


#ifndef MAPSCALE_H
#define MAPSCALE_H

#include <QWidget>

class QLineF;

/**
 * @brief Map distance scale
 *
 * @author Kaj Wallin - kaj.wallin (at) ixonos.com
 */
class MapScale : public QWidget
{
    Q_OBJECT

public:
    /**
     * @brief Constructor
     *
     * @param parent Parent
     */
    MapScale(QWidget *parent = 0);

/*******************************************************************************
 * BASE CLASS INHERITED AND REIMPLEMENTED MEMBER FUNCTIONS
 ******************************************************************************/
    /**
     * @brief Event handler for paint events
     *
     * Paints the scale
     * @param event Paint event
     */
    void paintEvent(QPaintEvent *event);

/******************************************************************************
 * MEMBER FUNCTIONS AND SLOTS
 ******************************************************************************/
private:
    /**
     * @brief Rounding function for distances
     *
     * Rounds the given value to closest 1,2,5 or 10 in the original scale
     * @param value Value to be rounded
     * @return qreal Rounded value
     */
    qreal roundToBaseScale(qreal value);

public slots:
    /**
     * @brief Slot to update the scale with latest resolution
     *
     * @param resolution Resolution of the map in meters/pixel
     */
    void updateMapResolution(const qreal &resolution);

/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/
private:
    qreal m_centerLineImperial;     ///< Length of the imperial scale
    qreal m_centerLineMetric;       ///< Length of the metric scale
    QString m_imperialText;         ///< Text description of the imperial scale
    QString m_metricText;           ///< Text description of the metric scale
};

#endif // MAPSCALE_H
