/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

      Henri Lampela - henri.lampela@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef LOGINDIALOG_H
#define LOGINDIALOG_H

#include <QDialog>

class QDialogButtonBox;
class QLabel;
class QLineEdit;
class QPushButton;

/**
* @brief Custom login dialog. Email and password inserted into dialog will be forwarded to webview
*        Email and password will not be saved.
*
* @author Henri Lampela
*/
class LoginDialog : public QDialog
{
    Q_OBJECT

public:

    /**
    * @brief Default constructor
    *
    * @param parent Instance of parent widget
    */
    LoginDialog(QWidget *parent = 0);

    /**
    * @brief Gets email and password
    *
    * @param email Email address
    * @param password Password
    */
    void userInput(QString &email, QString &password);

/*******************************************************************************
 * MEMBER FUNCTIONS AND SLOTS
 ******************************************************************************/

public slots:

    /**
    * @brief Sets email address to emailEdit field
    *
    * @param email E-mail address to be set
    */
    void setEmailField(const QString &email);

    /**
    * @brief Clears line edits
    *
    */
    void clearTextFields();

/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/

private:

    QLineEdit *m_emailEdit; ///< Pointer to email line edit
    QLineEdit *m_passwordEdit; ///< Pointer to password line edit
};

#endif // LOGINDIALOG_H
