/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Pekka Nissinen - pekka.nissinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#include <QSize>
#include <QDebug>
#include <QPixmap>
#include <QPainter>

#include "imagebutton.h"

ImageButton::ImageButton(QWidget *parent, QString normalIconPictureFileName,
                         QString selectedIconPictureFileName)
    : QPushButton(parent),
      m_buttonMode(QIcon::Normal)
{
    qDebug() << __PRETTY_FUNCTION__;

    // If there is a file name provided for icon image, use it as the icon for the button
    if (!normalIconPictureFileName.isEmpty()) {
        QPixmap iconPixmap(normalIconPictureFileName);
        QSize buttonSize = iconPixmap.size(); // Get the button size from the normal state icon picture
        QIcon icon(iconPixmap);

        // If there is a picture for selected state, use it instead of a simple highlight change
        if(!selectedIconPictureFileName.isEmpty())
            icon.addFile(selectedIconPictureFileName, buttonSize, QIcon::Selected);

        initButton(buttonSize, icon);
    }
}

void ImageButton::setButtonIcon(const QPixmap &image)
{
    qDebug() << __PRETTY_FUNCTION__;

    QSize buttonSize = image.size(); // Get the button size from the normal state icon picture
    QIcon icon(image);

    initButton(buttonSize, icon);
}

void ImageButton::mousePressEvent(QMouseEvent *event)
{
    qDebug() << __PRETTY_FUNCTION__;

    if(m_buttonMode != QIcon::Disabled) {
        QPushButton::mousePressEvent(event);
        setMode(QIcon::Selected);
    } else {
        setDown(true);
        emit pressed();
    }
}

void ImageButton::mouseReleaseEvent(QMouseEvent *event)
{
    qDebug() << __PRETTY_FUNCTION__;

    if(m_buttonMode != QIcon::Disabled) {
        QPushButton::mouseReleaseEvent(event);
        setMode(QIcon::Normal);
    } else {
        setDown(false);
        emit released();
    }
}

void ImageButton::paintEvent(QPaintEvent *event)
{
    qDebug() << __PRETTY_FUNCTION__;

    Q_UNUSED(event);

    QPainter painter(this);
    icon().paint(&painter, this->rect(), NULL, m_buttonMode);
}

void ImageButton::setMode(QIcon::Mode mode)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_buttonMode = mode;
    update();
}

QIcon::Mode ImageButton::mode()
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_buttonMode;
}

void ImageButton::initButton(const QSize &size, const QIcon &icon)
{
    qDebug() << __PRETTY_FUNCTION__;

    setIcon(icon);
    setIconSize(size);
    setFixedSize(size);
}
