 /*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Kaj Wallin - kaj.wallin@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
 */

#include "fullscreenbutton.h"
#include "math.h"

const int ROUNDING_RADIUS = 5;  ///< Roundness of the rounded edge
const qreal OPACITY = 0.13;     ///< Opacity of the background in percents

FullScreenButton::FullScreenButton(QWidget *parent) :
    QToolButton(parent)
{
    setIcon(QIcon::fromTheme(QLatin1String("general_fullsize")));
    setFixedSize(sizeHint());

    QPalette pal = palette();
    QColor backgroundColor = pal.color(backgroundRole());
    backgroundColor.setAlpha(floor(OPACITY * 255));  //
    pal.setColor(backgroundRole(), backgroundColor);
    setPalette(pal);

    setAutoFillBackground(true);

    // Create mask to round the top left corner of the background
    QRegion maskbase(rect());
    QRegion cookiecutterbase(QRect(QPoint(0,0),QPoint(ROUNDING_RADIUS, ROUNDING_RADIUS)));
    QRegion cookiecuttersplice(QRect(0,0,2*ROUNDING_RADIUS, 2*ROUNDING_RADIUS),QRegion::Ellipse);
    QRegion cookiecutter = cookiecutterbase.subtract(cookiecuttersplice);
    QRegion mask = maskbase.subtract(cookiecutter);

    setMask(mask);
}
