/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#include <QVBoxLayout>
#include <QDebug>
#include <QLabel>

#include "friendlistview.h"
#include "friendlistitem.h"
#include "../user/user.h"

FriendListView::FriendListView(QWidget *parent)
    : QWidget(parent)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_friendListLayout = new QVBoxLayout(this);
    m_friendListLayout->setMargin(0);
    m_friendListLayout->setSpacing(0);
    m_friendListLayout->setStretch(0, 0);
    m_friendListLayout->setSizeConstraint(QLayout::SetFixedSize);

    this->setLayout(m_friendListLayout);
}

void FriendListView::addWidget(const QString &key, QWidget *widget)
{
    qDebug() << __PRETTY_FUNCTION__;

    if (!m_widgets.contains(key)) {
        m_friendListLayout->addWidget(widget);
        m_widgets.insert(key, widget);
    }
}

void FriendListView::addWidgetToView(FriendListItem *item)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_friendListLayout->addWidget(item);
}

void FriendListView::clearUnused(const QStringList &userIDs)
{
    qDebug() << __PRETTY_FUNCTION__;

    foreach (QString key, m_widgets.keys()) {
        if (!userIDs.contains(key)) {
            QWidget *widget = m_widgets.value(key);
            if (widget) {
                m_friendListLayout->removeWidget(widget);
                disconnect(widget, 0, 0, 0);
                delete widget;
                m_widgets.remove(key);
            }
        }
    }
}

void FriendListView::filter(const QList<QString> &userIDs)
{
    qDebug() << __PRETTY_FUNCTION__;

    foreach (QWidget *widget, m_widgets)
        widget->hide();

    foreach (QString userID, userIDs) {
        QWidget *widget = m_widgets.value(userID);
        if (widget)
            widget->show();
    }
}

void FriendListView::clearFilter()
{
    qDebug() << __PRETTY_FUNCTION__;

    foreach (QWidget *widget, m_widgets)
        widget->show();
}

bool FriendListView::contains(const QString &userID)
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_widgets.contains(userID);
}

FriendListItem *FriendListView::widget(const QString &userID)
{
    qDebug() << __PRETTY_FUNCTION__;

    return static_cast<FriendListItem*>(m_widgets.value(userID));
}

FriendListItem *FriendListView::takeWidgetFromView(const QString &userID)
{
    qDebug() << __PRETTY_FUNCTION__;

    FriendListItem *item = widget(userID);
    m_friendListLayout->removeWidget(item);
    return item;
}
