/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jukka Saastamoinen - jukka.saastamoinen@ixonos.com
       Jussi Laitinen - jussi.laitinen@ixonos.com
       Ville Tiensuu - ville.tiensuu@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#include "avatarimage.h"
#include <QPainter>
#include <QDebug>

// constants for normal images
const int IMAGE_WIDTH = 64;     ///< Created image width
const int IMAGE_HEIGHT = 64;    ///< Created image height
const int ORIGINAL_IMAGE_X = 7; ///< Original image x position
const int ORIGINAL_IMAGE_Y = 7; ///< Original image y position
const int ROUNDNESS = 9;        ///< Image roundness
const int CLIP_X_OFFSET = 1;    ///< Clip

// constants for large images
const int BORDER_HEIGHT = 118; ///< Height of large profile image border
const int BORDER_OFFSET = 9; ///< Transparent area in border graphics edges
const int IMAGE_MAX_WIDTH = 220; ///< Mamimum allowed width for profile image
const int LEFT_BORDER_WIDTH = 20; ///< Width of large profile image left border
const int RIGHT_BORDER_WIDHT = 20; ///< Width of large profile image right border

QPixmap AvatarImage::create(const QPixmap &image, ImageHeight height)
{
    qDebug() << __PRETTY_FUNCTION__;

    if (height == Small) {
        QPixmap avatarImage = QPixmap(IMAGE_WIDTH, IMAGE_HEIGHT);
        avatarImage.fill(Qt::transparent);
        QPainter painter(&avatarImage);

        QRect imageRect = QRect(0, 0, image.width(), image.height());

        QPainterPath roundedRect;
        roundedRect.addRoundedRect(ORIGINAL_IMAGE_X-1, ORIGINAL_IMAGE_Y-1, imageRect.width()+1,
                                   imageRect.height()+1,ROUNDNESS,ROUNDNESS);
        painter.save();
        painter.setClipPath(roundedRect);
        painter.drawPixmap(QPointF(ORIGINAL_IMAGE_X, ORIGINAL_IMAGE_Y), image);
        painter.restore();
        painter.drawPixmap(0, 0, IMAGE_WIDTH, IMAGE_HEIGHT,
                           QPixmap(":/res/images/profile_pic_border.png"));

        return avatarImage;
    } else if (height == Large) {
        qDebug() << "Avatarimage original size: " << image.width() << image.height();

        QPixmap scaledProfileImage = image.scaledToHeight(height,
                                                          Qt::SmoothTransformation);

        qDebug() << "Avatarimage scaled size:  "
                   << scaledProfileImage.width() << scaledProfileImage.height();

        //  unsupported image size ratios are drawn without borders.
        if (scaledProfileImage.width() + 2*BORDER_OFFSET > IMAGE_MAX_WIDTH)
            return image;

        else if (scaledProfileImage.width() < 2*LEFT_BORDER_WIDTH)
            return image;

        else {

            QPixmap avatarImage = QPixmap(scaledProfileImage.width()+BORDER_OFFSET*2,
                                          BORDER_HEIGHT);
            avatarImage.fill(Qt::transparent);
            QPainter painter(&avatarImage);

            QPainterPath roundedRect;
            roundedRect.addRoundedRect(BORDER_OFFSET, BORDER_OFFSET, scaledProfileImage.width(),
                                       height, ROUNDNESS, ROUNDNESS);
            painter.save();
            painter.setClipPath(roundedRect);
            painter.drawPixmap(QPointF(BORDER_OFFSET, BORDER_OFFSET), scaledProfileImage);
            painter.restore();

            QRect leftFrameRectangle(0,0, LEFT_BORDER_WIDTH, BORDER_HEIGHT);
            QRect middleFrameRectangle(LEFT_BORDER_WIDTH, 0,
                                       scaledProfileImage.width() - LEFT_BORDER_WIDTH
                                       - RIGHT_BORDER_WIDHT + 2*BORDER_OFFSET, BORDER_HEIGHT);
            QRect rightFrameRectangle(LEFT_BORDER_WIDTH + middleFrameRectangle.width(), 0,
                                      RIGHT_BORDER_WIDHT, BORDER_HEIGHT);

            painter.drawPixmap(leftFrameRectangle,
                               QPixmap(":/res/images/large_profile_pic_border_left.png"));
            painter.drawPixmap(middleFrameRectangle,
                               QPixmap(":/res/images/large_profile_pic_border_middle.png"));
            painter.drawPixmap(rightFrameRectangle,
                               QPixmap(":/res/images/large_profile_pic_border_right.png"));

            return avatarImage;
        }
    }

    return image;
}
