/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef NETWORKHANDLERPRIVATESTUB_H
#define NETWORKHANDLERPRIVATESTUB_H

#include <QObject>

class NetworkHandler;

/**
* @brief NetworkHandlerPrivate class does nothing.
*
* Class is used when compiling in desktop.
*/
class NetworkHandlerPrivate : public QObject
{
    Q_OBJECT

public:
    /**
    * @brief Constructor.
    *
    * @param parent QObject
    */
    NetworkHandlerPrivate(QObject *parent);

/*******************************************************************************
 * MEMBER FUNCTIONS AND SLOTS
 ******************************************************************************/
public:
    /**
    * @brief Requests network connection.
    *
    * DOES NOTHING.
    */
    void connect();

    /**
    * @brief Requests to disconnect a connection.
    *
    * DOES NOTHING.
    */
    void disconnect();

    /**
    * @brief Checks if connected to network.
    *
    * RETURNS TRUE.
    */
    bool isConnected();

    /**
    * @brief Requests network state.
    *
    * DOES NOTHING.
    */
    void state();

private slots:
    /**
    * @brief emits connection state
    *
    */
    void connected();

private:
    NetworkHandler *m_parent;       ///< Parent object
};

#endif // NETWORKHANDLERPRIVATESTUB_H
