/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef NETWORKHANDLERPRIVATE_H
#define NETWORKHANDLERPRIVATE_H

#include <QtDBus>

class NetworkHandler;

/**
* @brief NetworkHandlerPrivate class.
*
* This class handles network connection. Class notifies about
* network connection states.
*/
class NetworkHandlerPrivate : public QObject
{
    Q_OBJECT

public:
    /**
    * @brief Constructor.
    *
    * Creates ICD D-Bus interface.
    */
    NetworkHandlerPrivate(QObject *parent);

/*******************************************************************************
 * MEMBER FUNCTIONS AND SLOTS
 ******************************************************************************/
public:
    /**
    * @brief Requests network connection.
    *
    * Request is done via ICD D-Bus.
    */
    void connect();

    /**
    * @brief Requests to disconnect a connection.
    *
    * Request is done via ICD D-Bus.
    */
    void disconnect();

    /**
    * @brief Checks if connected to network.
    *
    * @return true if connected, false otherwise
    */
    bool isConnected();

    /**
    * @brief Requests network state.
    */
    void state();

private slots:
    /**
    * @brief Slot for ICD D-Bus state change.
    *
    * @param message received D-Bus message
    */
    void stateChanged(const QDBusMessage &message);

/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/
private:
    QDBusInterface *dBusInterface;  ///< D-Bus interface
    bool m_connected;               ///< Connection state variable
    bool m_connecting;              ///< Connecting state variable

    NetworkHandler *m_parent;       ///< Parent object
};

#endif // NETWORKHANDLERPRIVATE_H
