/*
    Situare - A location system for Facebook
    Copyright (C) 2010  Ixonos Plc. Authors:

        Henri Lampela - henri.lampela@ixonos.com

    Situare is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    Situare is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Situare; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef NETWORKCOOKIEJAR_H
#define NETWORKCOOKIEJAR_H

#include <QNetworkCookieJar>

/**
* @brief Sub-class of QNetworkCookieJar, needed for cookie saving
*
* @author Henri Lampela
*/
class NetworkCookieJar : public QNetworkCookieJar
{
    Q_OBJECT

public:

    /**
    * @brief Constructor
    *
    * @param parent Instance of parent
    */
    explicit NetworkCookieJar(QObject *parent = 0);

/*******************************************************************************
 * BASE CLASS INHERITED AND REIMPLEMENTED MEMBER FUNCTIONS
 ******************************************************************************/

    /**
    * @brief Sets all network cookies
    *
    * @param cookieList Network cookie list
    */
    void setAllCookies ( const QList<QNetworkCookie> & cookieList );

    /**
    * @brief Gets all networks cookies
    *
    * @return QList<QNetworkCookie> Network cookie list
    */
    QList<QNetworkCookie> allCookies() const;

    /**
    * @brief Sets network cookies from url
    *
    * @param cookieList Network cookie list
    * @param url Url
    * @return bool Return value
    */
    bool setCookiesFromUrl(const QList<QNetworkCookie> &cookieList, const QUrl &url);

    /**
    * @brief Empty implementation
    *
    * @param url Url
    * @return QList<QNetworkCookie> Network cookie list
    */
    QList<QNetworkCookie> cookiesForUrl(const QUrl & url) const;

/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/

private:

    QList<QNetworkCookie> m_cookieList; ///< Placeholder for network cookies

};

#endif // NETWORKCOOKIEJAR_H
