/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#include <QDebug>

#include "common.h"
#include "gpsposition.h"
#include "gpspositionprivatestub.h"

GPSPositionPrivate::GPSPositionPrivate(QObject *parent)
    : QObject(parent)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_parent = static_cast<GPSPosition*>(parent);
}

bool GPSPositionPrivate::isInitialized()
{
    qDebug() << __PRETTY_FUNCTION__;

    return false;
}

bool GPSPositionPrivate::isRunning()
{
    qDebug() << __PRETTY_FUNCTION__;

    return false;
}

void GPSPositionPrivate::setUpdateInterval(int interval)
{
    qDebug() << __PRETTY_FUNCTION__;

    Q_UNUSED(interval);
}

void GPSPositionPrivate::setMode(GPSPosition::Mode mode, const QString &filePath)
{
    qDebug() << __PRETTY_FUNCTION__;

    Q_UNUSED(mode);
    Q_UNUSED(filePath);
}

void GPSPositionPrivate::setPowerSave(bool enabled)
{
    qDebug() << __PRETTY_FUNCTION__;

    Q_UNUSED(enabled);
}

void GPSPositionPrivate::start()
{
    qDebug() << __PRETTY_FUNCTION__;

    emit m_parent->error(ErrorContext::SITUARE, SituareError::GPS_INITIALIZATION_FAILED);
}

void GPSPositionPrivate::stop()
{
    qDebug() << __PRETTY_FUNCTION__;
}

QPointF GPSPositionPrivate::lastPosition()
{
    qDebug() << __PRETTY_FUNCTION__;

    return QPointF(0, 0);
}

void GPSPositionPrivate::requestLastPosition()
{
    qDebug() << __PRETTY_FUNCTION__;
}

void GPSPositionPrivate::requestUpdate()
{
    qDebug() << __PRETTY_FUNCTION__;
}
