/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#ifndef MCEPRIVATE_H
#define MCEPRIVATE_H

#include <QtDBus/QDBusInterface>
#include <QtDBus/QDBusMessage>

class MCE;

/**
* @brief MCEPrivate class.
*
* Mode Control Entity (MCE) listens changes in phone state.
*/
class MCEPrivate : public QObject
{
    Q_OBJECT

public:
    /**
    * @brief Constructor.
    *
    * @param parent QObject
    */
    MCEPrivate(QObject *parent);

/*******************************************************************************
 * MEMBER FUNCTIONS AND SLOTS
 ******************************************************************************/
public:
    /**
    * @brief Is the display on.
    *
    * @return true if on, false if off.
    */
    bool isDisplayOn();

private slots:
    /**
    * @brief Slot for display state changed.
    *
    * @return message QDBusMessage
    */
    void displayStateChanged(const QDBusMessage &message);

    /**
    * @brief Display state error.
    *
    * @param error QDBusError
    */
    void displayStateError(const QDBusError &error);

    /**
    * @brief Sets display state.
    *
    * @param state display state
    */
    void setDisplayState(const QString &state);

/*******************************************************************************
 * DATA MEMBERS
 ******************************************************************************/
private:
    bool m_displayOn;                 ///< Flag for display on/off
    QDBusInterface *m_dBusInterface;  ///< D-Bus interface
    MCE *m_parent;                    ///< Parent object
};

#endif // MCEPRIVATE_H
