/*
   Situare - A location system for Facebook
   Copyright (C) 2010  Ixonos Plc. Authors:

       Jussi Laitinen - jussi.laitinen@ixonos.com

   Situare is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   version 2 as published by the Free Software Foundation.

   Situare is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Situare; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
   USA.
*/

#include <QString>
#include <QDebug>
#include <QTimer>

#include <mce/dbus-names.h>
#include <mce/mode-names.h>

#include "mce.h"
#include "mceprivate.h"

const int DISPLAY_STATE_INDEX = 0;

static QDBusConnection dBusConnection = QDBusConnection::systemBus();

MCEPrivate::MCEPrivate(QObject *parent)
    : QObject(parent),
      m_displayOn(true)
{
    qDebug() << __PRETTY_FUNCTION__;

    m_parent = static_cast<MCE*>(parent);

    m_dBusInterface = new QDBusInterface(MCE_SERVICE, MCE_REQUEST_PATH,
                                       MCE_REQUEST_IF, dBusConnection, this);

    dBusConnection.connect(MCE_SERVICE, MCE_SIGNAL_PATH, MCE_SIGNAL_IF,
                           MCE_DISPLAY_SIG, this, SLOT(displayStateChanged(const QDBusMessage &)));

    m_dBusInterface->callWithCallback(MCE_DISPLAY_STATUS_GET, QList<QVariant>(), this,
                                      SLOT(setDisplayState(QString)),
                                      SLOT(displayStateError(QDBusError)));
}

void MCEPrivate::displayStateChanged(const QDBusMessage &message)
{
    qDebug() << __PRETTY_FUNCTION__;

    QString state = message.arguments().at(DISPLAY_STATE_INDEX).toString();
    setDisplayState(state);
}

void MCEPrivate::displayStateError(const QDBusError &error)
{
    qDebug() << __PRETTY_FUNCTION__;

    Q_UNUSED(error);
}

bool MCEPrivate::isDisplayOn()
{
    qDebug() << __PRETTY_FUNCTION__;

    return m_displayOn;
}

void MCEPrivate::setDisplayState(const QString &state)
{
    qDebug() << __PRETTY_FUNCTION__;

    if (!state.isEmpty()) {
        if (state == MCE_DISPLAY_ON_STRING) {
            m_displayOn = true;
            emit m_parent->displayStateChanged(true);
        }
        else if (state == MCE_DISPLAY_OFF_STRING) {
            m_displayOn = false;
            emit m_parent->displayStateChanged(false);
        }
    }
}
