#!/bin/sh

if [ `id -u` != 0 ] ; then
   exec root <<EOF
exec sh $0 $*
EOF
	exit $?
fi 

data=`python /opt/alarmed/alarmed.py -C -L |grep datetime |awk -F ':' '{print $2}'| awk -F ',' '{print $1}'`
ora=`python /opt/alarmed/alarmed.py -C -L |grep datetime |awk '{print $3}'`

esiste=`python /opt/alarmed/alarmed.py -C -L |grep title |awk '{print $2}' |grep -c ServizioPubblico`

if [ $esiste -eq 1 ]
	then
		numero=`zenity --entry --title "Invia promemoria" --text="Inserisci uno o più numeri divisi da ':'" --entry-text="es. +393401234567:+393330987654"`
		if [ $? -eq 0 ]
			then
				ok=`smssend -C -n $numero -m "Ricordati della puntata di Servizio Pubblico del $data alle ore $ora - inviato da ServizioPubblico per N900" |grep -c Sending`
				if [ $ok -eq 1 ]
					then
						dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Messaggio in invio..."
					else
						dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteDialog string:"Ci sono stati problemi nell'invio, ricontrolla il numero!" uint32:0 string:"OK"
				fi
			else
				dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Operazione annullata!"
		fi
	else
		dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteDialog string:"Devi prima creare un promemoria, procedi con Opzioni→Crea Promemoria" uint32:0 string:"OK"
fi
