#include <gucharmap/gucharmap.h>

#include "scv-marshallers.h"
#include "maemo-gucharmap-chartable.h"

struct _MaemoGucharmapChartable
{
	GucharmapChartable __parent_instance__;

	GtkAdjustment *my_hadj;
	GtkAdjustment *my_vadj;
	GtkAdjustment *foreign_hadj;
	GtkAdjustment *foreign_vadj;
};

struct _MaemoGucharmapChartableClass
{
	GucharmapChartableClass __parent_class__;
};

static void maemo_gucharmap_chartable_init(MaemoGucharmapChartable *chart);
static void maemo_gucharmap_chartable_class_init(MaemoGucharmapChartableClass *chart_class);

G_DEFINE_TYPE(MaemoGucharmapChartable, maemo_gucharmap_chartable, GUCHARMAP_TYPE_CHARTABLE);

#define PERFORM_SYNC(mvte,src) \
  ((mvte)->priv->foreign_vadj && \
   (((mvte)->priv->pan_mode) || \
    ((src) != (mvte)->priv->foreign_vadj)))

static void
set_up_sync(GtkAdjustment **p_src,
						GtkAdjustment **p_dst,
						GtkAdjustment *my_adj,
						GtkAdjustment *foreign_adj,
						double *p_factor,
						double dim_in_pixels)
{
//	if (!(foreign_adj && (*p_src) != foreign_adj))
//    (*p_src) = my_adj;

  if ((*p_src) == foreign_adj) {
    (*p_dst) = my_adj;
    (*p_factor) = 1.0 / dim_in_pixels;
  }
  else {
    (*p_dst) = foreign_adj;
    (*p_factor) = dim_in_pixels;
  }
}

const char *
str_from_adj(MaemoGucharmapChartable *chart, GtkAdjustment *adj)
{
	return adj == chart->my_hadj      ? "MH" :
	       adj == chart->my_vadj      ? "MV" :
				 adj == chart->foreign_hadj ? "FH" :
				 adj == chart->foreign_vadj ? "FV" : "??";
}

static void
sync_adj(GtkAdjustment *src, MaemoGucharmapChartable *chart)
{
	GtkAdjustment *dst;
	double factor;

	if (src == chart->my_hadj || src == chart->foreign_hadj)
		set_up_sync(&src, &dst, chart->my_hadj, chart->foreign_hadj, &factor, 100.0);
	else
	if (src == chart->my_vadj || src == chart->foreign_vadj)
		set_up_sync(&src, &dst, chart->my_vadj, chart->foreign_vadj, &factor, 100.0);

	if (!(src && dst)) return;

	if (!(dst->upper          == src->upper * factor && 
	      dst->lower          == src->lower * factor && 
	      dst->step_increment == src->step_increment * factor && 
	      dst->page_increment == src->page_increment * factor && 
	      dst->page_size      == src->page_size * factor)) {
		dst->upper          = src->upper * factor;
		dst->lower          = src->lower * factor;
		dst->step_increment = src->step_increment * factor;
		dst->page_increment = src->page_increment * factor;
		dst->page_size      = src->page_size * factor;
		gtk_adjustment_changed(dst);
	}	
}

static void
sync_adj_value(GtkAdjustment *src, MaemoGucharmapChartable *chart)
{
	GtkAdjustment *dst;
	double factor, new_val;

	if (src == chart->my_hadj || src == chart->foreign_hadj)
		set_up_sync(&src, &dst, chart->my_hadj, chart->foreign_hadj, &factor, 100.0);
	else
	if (src == chart->my_vadj || src == chart->foreign_vadj)
		set_up_sync(&src, &dst, chart->my_vadj, chart->foreign_vadj, &factor, 100.0);

	if (!(src && dst)) return;

	new_val = src->value * factor;

	if (dst->value != new_val) {
		dst->value = new_val;
		gtk_adjustment_value_changed(dst);
	}
}

static void
move_to_new_adj(MaemoGucharmapChartable *chart, GtkAdjustment **p_adj, GtkAdjustment *my_adj, GtkAdjustment *new_adj)
{
	if ((*p_adj)) {
		g_signal_handlers_disconnect_by_func(G_OBJECT((*p_adj)), sync_adj,       chart);
		g_signal_handlers_disconnect_by_func(G_OBJECT((*p_adj)), sync_adj_value, chart);
		g_signal_handlers_disconnect_by_func(G_OBJECT(my_adj),   sync_adj,       chart);
		g_signal_handlers_disconnect_by_func(G_OBJECT(my_adj),   sync_adj_value, chart);
		g_object_unref((*p_adj));
		(*p_adj) = NULL;
	}

	if (new_adj) {
		(*p_adj) = g_object_ref(new_adj);
		g_signal_connect(G_OBJECT(new_adj), "changed",       (GCallback)sync_adj,       chart);
		g_signal_connect(G_OBJECT(new_adj), "value-changed", (GCallback)sync_adj_value, chart);
		g_signal_connect(G_OBJECT(my_adj),  "changed",       (GCallback)sync_adj,       chart);
		g_signal_connect(G_OBJECT(my_adj),  "value-changed", (GCallback)sync_adj_value, chart);
	}
}

static void
set_scroll_adjustments(GucharmapChartable *chart, GtkAdjustment *hadjustment, GtkAdjustment *vadjustment)
{
	MaemoGucharmapChartable *maemo_chart = MAEMO_GUCHARMAP_CHARTABLE(chart);

	move_to_new_adj(maemo_chart, &(maemo_chart->foreign_hadj), maemo_chart->my_hadj, hadjustment);
	move_to_new_adj(maemo_chart, &(maemo_chart->foreign_vadj), maemo_chart->my_vadj, vadjustment);
}

static gboolean
button_press_event(GtkWidget *widget, GdkEventButton *event)
{
	return GTK_WIDGET_CLASS(maemo_gucharmap_chartable_parent_class)->button_press_event(widget, event);
}

static void
maemo_gucharmap_chartable_init(MaemoGucharmapChartable *chart)
{
	chart->foreign_hadj = NULL;
	chart->foreign_vadj = NULL;

	chart->my_hadj = g_object_new(GTK_TYPE_ADJUSTMENT, NULL);
	chart->my_vadj = g_object_new(GTK_TYPE_ADJUSTMENT, NULL);
	GUCHARMAP_CHARTABLE_CLASS(maemo_gucharmap_chartable_parent_class)->set_scroll_adjustments(GUCHARMAP_CHARTABLE(chart), chart->my_hadj, chart->my_vadj);

	g_signal_connect(G_OBJECT(chart->my_hadj), "changed",       (GCallback)sync_adj,       chart);
	g_signal_connect(G_OBJECT(chart->my_hadj), "value-changed", (GCallback)sync_adj_value, chart);
	g_signal_connect(G_OBJECT(chart->my_vadj), "changed",       (GCallback)sync_adj,       chart);
	g_signal_connect(G_OBJECT(chart->my_vadj), "value-changed", (GCallback)sync_adj_value, chart);
}

static void
maemo_gucharmap_chartable_class_init(MaemoGucharmapChartableClass *chart_class)
{
	GtkWidgetClass *gtkwidget_class = GTK_WIDGET_CLASS(chart_class);
	GucharmapChartableClass *gucc_class = GUCHARMAP_CHARTABLE_CLASS(chart_class);

	gucc_class->set_scroll_adjustments = set_scroll_adjustments;
	gtkwidget_class->button_press_event = button_press_event;
}

