#!/usr/bin/env python
# -*- coding: utf-8 -*-

from PyQt4.QtGui import *
from PyQt4.QtCore import *
from PyQt4.QtMaemo5 import *
import math
import station

_RAYON = station._RAYON
_TEMPS_ANIM = 1000
_TEMPS_CLICK = 750

#FOND = View

class Fond(QGraphicsView):

    def __init__(self, parent=None):
        super(Fond, self).__init__(parent)

        self.Scale = 1.0
        self.myFirstPoint = QPoint(0,0)
        self.myCurrentPoint = QPoint(0,0)
        self.myFirstScale  = 1.0
        self.myOrig = QPointF(400, 200)
        self.zooming = False
        self.dblClicked = False

        self.animSeq = QSequentialAnimationGroup()
        self.animSeq.finished.connect(self.animSeq.clear)
        
        self.animPar = QParallelAnimationGroup()
        self.animPar.finished.connect(self.animPar.clear)


###Events

    def resizeEvent ( self, event ):
        self.emit(SIGNAL("resized()"))

    def mousePressEvent(self,event):
        self.emit(SIGNAL("pressed()"))
        self.myFirstPoint = event.pos()
        QGraphicsView.mousePressEvent (self, event)

    def mouseDoubleClickEvent(self, event):
        self.dblClicked = True
        QGraphicsView.mouseDoubleClickEvent (self, event)


    def mouseReleaseEvent(self,event):
        QObject.disconnect(self, SIGNAL("position(QPointF)"), self.zoom)
        if not self.zooming and self.dblClicked:
            self.scene().doubleClick(self.mapToScene(event.pos()))
        self.zooming = False
        self.dblClicked = False
        QGraphicsView.mouseReleaseEvent (self, event)        

    def mouseMoveEvent(self,event):
        if not self.zooming:
            if not QRect( self.myFirstPoint-QPoint(10,10) , self.myFirstPoint+QPoint(10,10)).contains(event.pos()):
                if self.dblClicked:
                    self.zooming = True
                    QObject.connect(self, SIGNAL("position(QPointF)"), self.zoom)
                QGraphicsView.mouseMoveEvent (self, event)
        else:
            QGraphicsView.mouseMoveEvent (self, event)
        self.emit(SIGNAL("position(QPointF)"),event.posF())

###Actions

    def decalage(self,i):
        self.translate(i*2000,200)
        self.update() 

    def dist(self,A,B):
        return math.sqrt((A.x() - B.x())**2 + (A.y() - B.y())**2)
        
        
    def zoom(self,point):
        centre = QPointF(0,0)
        scale = self.dist(point,centre) / self.dist(self.myFirstPoint,centre) 
        self.multScale(scale)


    def multScale(self,scale):
        self.Scale = max(min(self.Scale * scale**.5, 6.),.2)
        if self.Scale != 6. and self.Scale != .2:
            self.scale( scale**.5, scale**.5)
#            self.emit(SIGNAL("zoom(float)"),scale**.5)
            
    def getScale(self):
        return self.Scale

    scaling = pyqtProperty(float, fget=getScale, fset=multScale)
        
    def setCenter(self,point):
        self.centerOn(point)
       
    def getCenter(self):
        return self.mapToScene(self.rect().center())

    center = pyqtProperty(QPointF, fget=getCenter, fset=setCenter)
    
    def goTo(self,point,scale,sign=1):

        self.animPar.stop()
        self.animPar.clear()
    
        anim = QPropertyAnimation (self, "center")
        anim.setDuration(_TEMPS_ANIM*2)
        anim.setEasingCurve(QEasingCurve.OutQuad)
        anim.setKeyValueAt(0, self.getCenter())
        anim.setKeyValueAt(1, point)
        self.animPar.addAnimation(anim)
        
        val = (2./scale)**(sign*.05)
        anim2 = QPropertyAnimation (self, "scaling")
        anim2.setDuration(_TEMPS_ANIM*2)
        anim2.setEasingCurve(QEasingCurve.Linear)
        anim2.setKeyValueAt(0, val)
        anim2.setKeyValueAt(1, val)
        self.animPar.addAnimation(anim2)
        

        

#CARTE  = Scene   

class Carte(QGraphicsScene):
    fond = QGraphicsRectItem ()
    fond.setBrush(QBrush(QColor(0,0,0,153)))
    
    blurred = False

    def doubleClick  ( self, p ):
        self.emit(SIGNAL("dblclicked(QPointF)"),p)
        
    def blur(self):
        self.fond.setRect(self.sceneRect())
        self.addItem(self.fond)
        blurred = True

    def unblur(self):
        self.removeItem(self.fond)
        blurred = False




      
      
#Panneau Station  

class PanStation(QLabel):   
    def __init__(self, parent=None):
        super(PanStation, self).__init__(parent)

        self.state = False
        self.setFont(QFont ( "Nokia Sans",_RAYON*2  ))
        self.setAlignment(Qt.AlignCenter)

        self.animX = QPropertyAnimation (self, "pos")
        self.animX.setDuration(_TEMPS_ANIM/5)
        self.animX.setEasingCurve(QEasingCurve.OutBack)

        self.animY = QPropertyAnimation (self, "pos")
        self.animY.setDuration(_TEMPS_ANIM/5)
        self.animY.setEasingCurve(QEasingCurve.OutBack)


    def playX(self,w,text=''):
        y = self.y()
        if not self.state and text != '':
            size = self.fontMetrics().size(Qt.TextSingleLine,text)
            
            self.resize(size.width()+_RAYON*2,70)
            self.setText(text)
            self.animX.setKeyValueAt(0, QPoint(900,y))
            self.animX.setKeyValueAt(1, QPoint(w-min(220,self.width()),y) )
            self.emit(SIGNAL("showing(int)"),-1)
            self.state = True
            self.animX.start()

        elif self.text() != '':
            self.setText(text)
            self.animX.setKeyValueAt(0, QPoint(w-min(220,self.width()),y))
            self.animX.setKeyValueAt(1, QPoint(900,y))
            self.emit(SIGNAL("showing(int)"),1)
            self.state = False
            self.animX.start()


    def mouseReleaseEvent(self,event):
        self.emit(SIGNAL("released(QString)"),self.text())
        QLabel.mouseReleaseEvent (self, event)


#Panneau  Action

class PanAction(QLabel):   
    def __init__(self, parent=None):
        super(PanAction, self).__init__(parent)
        
        self.setPixmap(QPixmap("/usr/share/icons/hicolor/48x48/hildon/statusarea_sharing_pending.png"))
        self.setScaledContents( True )
        self.setMargin(0)
        self.toggle = False
        self.text = ''
        self.state = False
        
        
        self.animX = QPropertyAnimation (self, "pos")
        self.animX.setDuration(_TEMPS_ANIM/5)
        self.animX.setEasingCurve(QEasingCurve.OutBack)

        self.animMargin = QPropertyAnimation (self, "margin")
        self.animMargin.setDuration(_TEMPS_ANIM)
        self.animMargin.setEasingCurve(QEasingCurve.OutBounce)
        self.animMargin.setKeyValueAt(0, 30)
        self.animMargin.setKeyValueAt(1, 6)


    def mousePressEvent(self,event):
        self.animMargin.setEasingCurve(QEasingCurve.OutElastic)
        self.animMargin.setKeyValueAt(0, 0)
        self.animMargin.start()
        if not self.toggle:
            self.setPixmap(QPixmap("/usr/share/icons/hicolor/48x48/hildon/statusarea_sharing.png"))
        QLabel.mousePressEvent (self, event)

        
    def toggling(self):
        self.toggle = True
        self.setPixmap(QPixmap("/usr/share/icons/hicolor/48x48/hildon/camera_playback.png"))
        self.animMargin.setEasingCurve(QEasingCurve.OutBounce)
        self.animMargin.setKeyValueAt(0, 20)
        self.animMargin.start()

    def showEvent(self,event):
        if not self.toggle:
            self.setPixmap(QPixmap("/usr/share/icons/hicolor/48x48/hildon/statusarea_sharing_pending.png"))
        else:
            self.setPixmap(QPixmap("/usr/share/icons/hicolor/48x48/hildon/camera_playback.png"))
        QWidget.showEvent (self, event)

    def mouseReleaseEvent(self,event):
        if not self.toggle:
            self.emit(SIGNAL("colorise"))
        else:
            self.emit(SIGNAL("play"))
        QLabel.mouseReleaseEvent (self, event)

    def playX(self,w,text=''):
        

        y = self.y()
        if not self.state and text != '':
            
            self.text = text
            self.animX.setKeyValueAt(0, QPoint(900,y))
            self.animX.setKeyValueAt(1, QPoint(w-100,y) )
            self.state = True
            self.animX.start()
            self.animMargin.start()

        elif self.text != '':
            self.text = text
            self.animX.setKeyValueAt(0, QPoint(w-100,y))
            self.animX.setKeyValueAt(1, QPoint(900,y))
            self.state = False
            self.toggle = False
            self.animX.start()
            self.setPixmap(QPixmap("/usr/share/icons/hicolor/48x48/hildon/statusarea_sharing_pending.png"))
            

#Boutton Du GPS

class GpsButton(QLabel):   
    def __init__(self, parent=None):
        super(GpsButton, self).__init__(parent)
        self.pixNo = QPixmap("/usr/share/icons/hicolor/32x32/hildon/camera_gps_location.png")
        self.pixOn = QPixmap("/usr/share/icons/hicolor/48x48/hildon/location_applet_track_start.png")
        self.pixGood = QPixmap("/usr/share/icons/hicolor/48x48/hildon/location_applet_track_stop_ani.png")
        self.pixOff = QPixmap("/usr/share/icons/hicolor/48x48/hildon/sketch_circle.png")
        
        self.setAlignment(Qt.AlignCenter)
        self.setPixmap (  self.pixNo)
        self.setScaledContents( True )
        self.setMargin(16)
        self.state = False
        self.fixed = False

        self.animMargin = QPropertyAnimation (self, "margin")
        self.animMargin.setDuration(_TEMPS_ANIM*1.5)
        self.animMargin.setEasingCurve(QEasingCurve.OutElastic)
        self.animMargin.setKeyValueAt(0, 8)
        self.animMargin.setKeyValueAt(1, 16)
        
        
        self.click = QTimer(self)
        self.click.setSingleShot (True )
        
    def center(self):
        #if self.state:
        self.emit(SIGNAL("gpsCenter"))
        self.click.stop()

    def mouseDoubleClickEvent(self, event):
        self.changeState()
        QLabel.mouseDoubleClickEvent (self, event)


        
    def mouseReleaseEvent(self,event):
        self.click.stop()
        QLabel.mouseReleaseEvent (self, event)
        

    def mousePressEvent(self,event):
        self.click.stop()
        self.click.start(_TEMPS_CLICK)
        self.animMargin.start()
        QLabel.mousePressEvent (self, event)
        
    def setPix(self,t):
        if t == 'On':
            self.setPixmap (  self.pixOn)
            self.animMargin.setKeyValueAt(0, 0)
            self.animMargin.setKeyValueAt(1, 8)
        elif t == 'Good':
            self.setPixmap (  self.pixGood)
        elif t == 'Off':
            self.setPixmap (  self.pixOff)
        elif t == 'No':
            self.setPixmap (  self.pixNo)
        

    def changeState(self):
        self.click.stop()
        if self.state:
            
            self.emit(SIGNAL("gpsOff"))
            self.setPix('Off')
#            QObject.disconnect(self.click, SIGNAL("timeout()"), self.center)
            self.state = False
            self.fixed = False

        elif self.fixed:
            self.animMargin.stop()
            self.animMargin.setLoopCount( 1 )
            self.setMargin(8)
            self.setPix('On')
            QObject.connect(self.click, SIGNAL("timeout()"), self.center)
            self.state = True
        else:
            self.setPix('No')
            self.emit(SIGNAL("gpsOn"))
            self.animMargin.stop()
            self.animMargin.setKeyValueAt(0, 8)
            self.animMargin.setKeyValueAt(1, 16)
            self.animMargin.setLoopCount( -1 )
            self.animMargin.start()



#Point du GPS        
        
class Gps(QGraphicsEllipseItem):
    def __init__(self, parent=None):
        super(Gps, self).__init__()
        
        self.setRect(0.,0., _RAYON*1, _RAYON*1)
        
        self.setBrush(Qt.green)

        gradient = QRadialGradient(0,0, _RAYON*1.5)
        gradient.setColorAt(1, Qt.red)
        gradient.setColorAt(0, Qt.red)
        self.setPen(QPen(gradient, _RAYON))
        self.state = False
        
    def width(self):
        return self.rect().width()

    def height(self):
        return self.rect().height()

    def selec(self):
        gradient = QRadialGradient(0,0, _RAYON*1.5)
        gradient.setColorAt(0, Qt.white)
        gradient.setColorAt(1, Qt.red)
        self.setPen(QPen( gradient, _RAYON))
        
   
    def deselec(self):
        gradient = QRadialGradient(0,0, _RAYON*1.5)
        gradient.setColorAt(1, Qt.red)
        gradient.setColorAt(0, Qt.red)
        self.setPen(QPen(gradient, _RAYON))
        
        

class diagSearch(QWidget):
    def __init__(self, graph, parent=None):
        super(diagSearch, self).__init__(parent)
        self.fond = QGraphicsRectItem (parent.scene().sceneRect())
        self.fond.setBrush(QBrush(QColor(0,0,0,153)))
        
        self.hide()
        self.setGeometry(50,50,parent.width()-100,65)
        self.graph = graph
        self.changed = True
        
      
        self.Line = QLineEdit(self)
#        self.Line.setStyleSheet("""QLineEdit {
#     border: 4px solid palette(highlight);
#     border-right : none;
#     border-radius: 32px;
#     padding-left: 16px;
#     padding-right : 80px;
#     color: white;
#     selection-background-color: white;
#     selection-color: black;
# }""")
        self.Line.setGeometry(0,0,self.width()-32,64)

        self.Search = QPushButton("Go",self)

        self.Search.setStyleSheet("QPushButton {font: bold 32px;border:4px solid white;color:white;border-radius: 32px;background-color: black;} QPushButton:pressed {background-color: palette(highlight);color:palette(highlighted-text);border-color:palette(highlighted-text);}")
        self.Search.setGeometry(self.width()-64,0,64,64)
        
        self.List = QListWidget(self)
#        self.List.setStyleSheet("QListView:item{border:2px solid white;border-top:0px ;color: white;}QListView:item:selected{border:4px solid white; color: black;background : white;}")
        self.List.itemDoubleClicked.connect(self.selec)
        self.List.setGeometry(32,64,0,0)
        self.List.setWordWrap ( True )

        self.Line.setFocus ( Qt.MouseFocusReason)
        self.Line.returnPressed.connect(self.cherche)
        self.Line.textChanged.connect(self.changing)
        self.Search.clicked.connect(self.cherche)
        QObject.connect(self.parent(), SIGNAL("pressed()"), self.close)
        
    def changing(self):
        self.changed = True
        
    def cherche(self):
        if self.changed:
            result = []
            self.List.clear()
            for element in self.graph:
                if str(self.Line.text().toLower()) in element.lower() and element[-1] != ']':
                    result += [element]
            if result == []:
                QMaemo5InformationBox.information( self, self.tr("La recherche n\'a donn\xe9 aucun r\xe9sultat.") )
            elif len(result) == 1 or str(self.Line.text()) in result:
                self.emit(SIGNAL("selected(QString)"),result[0])
                self.List.clear()
                self.List.hide()
                self.close()
            else:
                for stop in result:
                    self.List.addItem(stop)
                self.resize(self.width(),min(self.height()+74*len(result),self.parent().height()-100))
                self.List.resize(self.width()-64,min(74*len(result),self.height()-64))
                self.List.show()
                self.changed = False
        else:
            self.selec(self.List.currentItem())

        
    def selec(self,it):
        self.emit(SIGNAL("selected(QString)"),it.text())
        self.List.clear()
        self.List.hide()
        self.close()
        
    def rotate(self):
        self.resize(self.parent().width()-100,min(64+74*self.List.count(),self.parent().height()-100))
        self.Line.resize(self.width(),64)
        self.Search.setGeometry(self.width()-64,0,64,64)
        self.List.resize(self.width()-64, min(74*self.List.count(),self.height()-64))

    def showEvent(self,event):
        self.parent().scene().addItem(self.fond)
        QWidget.showEvent (self, event)


    def closeEvent(self,event):
        QObject.disconnect(self.parent(), SIGNAL("pressed()"), self.close)
        self.emit(SIGNAL("selected(QString)"),"")
        self.parent().scene().removeItem(self.fond)
        QWidget.closeEvent (self, event)


#diagLine dans le fichiers Station

        

class diagAbout(QWidget):   
    def __init__(self, parent=None):
        super(diagAbout, self).__init__(parent)
        self.fond = QGraphicsRectItem (parent.scene().sceneRect())
        self.fond.setBrush(QBrush(QColor(0,0,0,153)))
#        self.setWindowTitle("Rtap : \xc0 Propos")
        self.setGeometry(100,60,600,300)

        self.Layout = QGridLayout(self)
        self.Titre = QLabel(' Rtap ',self)
        self.Titre.setFont(QFont('Nokia Sans',48))
        self.Titre.setSizePolicy(QSizePolicy(QSizePolicy.Maximum, QSizePolicy.Fixed))
        self.Logo = QLabel(self)
        self.Logo.setPixmap(QPixmap("/home/user/Metro/Rtap_About.png"))
        self.Logo.setAlignment(Qt.AlignCenter)
        self.Text = QLabel(self.tr(""", les transports \xe0 Paris sur le N900 avec les doigts!

0.9.9 (C) 2011 LGPL
Ahc\xe8ne 'Opax' Boubekki
opax.gm@gmail.com
Veuillez reporter les bugs \xe0 la m\xeame adresse, merci!"""),self)
        self.Text.setFont(QFont('Nokia Sans',18))
        self.Text.setWordWrap(True)
        
        self.Layout.addWidget(self.Titre,0,0)
        self.Layout.addWidget(self.Logo,1,0)
        self.Layout.addWidget(self.Text,0,1,2,1)

        self.Fond = QGraphicsRectItem (parent.sceneRect())
        self.Fond.setBrush(QBrush(QColor(0,0,0,153)))
        QObject.connect(self.parent(), SIGNAL("pressed()"), self.close)
        self.rotate()

    def rotate(self):
        if self.parent().width() < self.parent().height():
            self.setGeometry(10,144,460,400)       
        else:
            self.setGeometry(100,60,600,340)

    def mousePressEvent(self,event):
        self.close()
        QWidget.mousePressEvent (self, event)
            
    def showEvent(self,event):
        self.parent().scene().addItem(self.fond)
        QWidget.showEvent (self, event)
        
    def closeEvent(self,event):
        QObject.disconnect(self.parent(), SIGNAL("pressed()"), self.close)
        self.emit(SIGNAL("closing()"))
        self.parent().scene().removeItem(self.fond)
        QWidget.closeEvent (self, event)

class diagAide(QWidget):   
    def __init__(self, parent=None):
        super(diagAide, self).__init__(parent)
        self.fond = QGraphicsRectItem (parent.scene().sceneRect())
        self.fond.setBrush(QBrush(QColor(0,0,0,153)))
#        self.setWindowTitle("Rtap : \xc0 Propos")
        self.setGeometry(100,60,600,300)



        self.Layout = QVBoxLayout(self)
        self.scroll = QScrollArea(self)
        self.Titre = QLabel(self.tr(" Aide "),self)
        self.Titre.setFont(QFont('Nokia Sans',48))
        self.Titre.setSizePolicy(QSizePolicy(QSizePolicy.Maximum, QSizePolicy.Fixed))
        self.Text = QTextEdit("<p align='center'><span style=' font-size:32pt; font-weight:600;'>"+self.tr("Carte")+"</span></p> \
<p><b>"+self.tr("S\xe9lection d'une station:")+"</b></p> \
<p>"+self.tr("Double-clique sur la station.")+"</p> \
<p><br /><b>"+self.tr("D\xe9placement:")+"</b></p> \
<p>"+self.tr("Clique et gliss\xe9.")+"<br /></p> \
<p><b>"+self.tr("Zoom: ")+"</b></p> \
<p>"+self.tr("Double-clique et gliss\xe9 vers le bas/droite.")+" \
<br /><br /><b>"+self.tr("d\xe9Zoom: ")+"</b></p> \
<p>"+self.tr("Double-clique et gliss\xe9 vers le haut/gauche.")+"</p> \
<p></p> \
<p><br /><b>GPS:</b></p> \
<p><img src='/usr/share/icons/hicolor/32x32/hildon/camera_gps_location.png' width='32' height='32'/> : "+self.tr("Double-clique pour activer la localisation.")+"</p> \
<p><img src='/usr/share/icons/hicolor/48x48/hildon/location_applet_track_start.png' width='32' height='32'/> : "+self.tr("GPS activ\xe9. Double-clique pour d\xe9sactiver la localisation.")+"</p> \
<p><img src='/usr/share/icons/hicolor/48x48/hildon/location_applet_track_stop_ani.png' width='32' height='32'/> : "+self.tr("Localisation précise. Double-clique pour désactiver la localisation.")+"</p> \
<p><img src='/usr/share/icons/hicolor/48x48/hildon/sketch_circle.png' width='32' height='32'/> : "+self.tr("GPS désactivé mais position enregistrée.")+"</p> \
<p>"+self.tr("Clique long (1s) pour centrer la carte la position GPS.")+"</p> \
<p></p> \
<p><br /><b>"+self.tr("Panneaux:")+"</b></p> \
<p><img src='/opt/rtap/img_panneaux.png'/> : "+self.tr("Clique pour cacher et d\xe9s\xe9lectionner la station.")+"</p> \
<p></p> \
<p><img src='/usr/share/icons/hicolor/48x48/hildon/statusarea_sharing_pending.png' width='32' height='32'/> : "+self.tr("Calculer l'itin\xe9raire.")+"</p> \
<p><img src='/usr/share/icons/hicolor/48x48/hildon/statusarea_sharing.png' width='32' height='32'/> : "+self.tr("Calcul en cours.")+"</p> \
<p><img src='/usr/share/icons/hicolor/48x48/hildon/camera_playback.png' width='32' height='32'/> : "+self.tr("Parcours de l'itin\xe9raire sur la carte.")+"</p> \
<p><br /></p> \
<p align='center'><span style=' font-size:32pt; font-weight:600;'>"+self.tr("Menu:")+"</span></p> \
<p><br /><b>"+self.tr("Recherche:")+"</b></p> \
<p>"+self.tr("S\xe9lection: Double clique.")+"</p> \
<p>"+self.tr("Sortir: Clique ailleurs.")+"</p> \
<p></p> \
<p><br /><b>"+self.tr("S\xe9lection des lignes:")+"</b></p> \
<p>"+self.tr("S\xe9lection/D\xe9s\xe9lection : Clique")+"</p> \
<p>"+self.tr("Les noms des stations sont affichés si maximum <b>quatre</b> lignes sont sélectionnées.")+"</p> \
<p>"+self.tr("Sortir/Valider: Clique ailleurs.")+"</p> \
<p></p> \
<p><br /><b>"+self.tr("Aide:")+"</b></p> \
<p>"+self.tr("Sortir: Clique ailleurs.")+"</p> \
<p></p> \
<p><br /><b>"+self.tr("\xc0 Propos:")+"</b></p> \
<p>"+self.tr("Sortir: Clique ailleurs.")+"</p> \
<p><br /></p>",self.scroll)
        self.Text.setFont(QFont('Nokia Sans',18))
        self.Text.setSizePolicy(QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed))
        self.Text.setReadOnly ( True )
#        self.Text.setWordWrap(True)
        
        self.Layout.addWidget(self.Titre)
        self.Layout.addWidget(self.scroll)
        self.scroll.setWidget(self.Text)
        QObject.connect(self.parent(), SIGNAL("pressed()"), self.close)
        self.rotate()

    def rotate(self):
        if self.parent().width() < self.parent().height():
            self.setGeometry(10,50,460,600)
            self.Text.resize(self.width()-40,2250)        
        else:
            self.setGeometry(100,60,600,340)
            self.Text.resize(self.width()-40,2000)

    def mousePressEvent(self,event):
        self.close()
        QWidget.mousePressEvent (self, event)

            
    def showEvent(self,event):
        self.parent().scene().addItem(self.fond)
        QWidget.showEvent (self, event)

        
    def closeEvent(self,event):
        QObject.disconnect(self.parent(), SIGNAL("pressed()"), self.close)
        self.emit(SIGNAL("closing()"))
        self.parent().scene().removeItem(self.fond)
        QWidget.closeEvent (self, event)
