/*************************************************************************}
{ equalizer.h - gstreamer equalizer wrapper                               }
{                                                                         }
{ This file is a part of the project                                      }
{   Rhapsodie - Music player for N900                                     }
{                                                                         }
{ (c) Alexey Parfenov, 2012                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This program is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This program is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 31 Mar 2012                                              }
{*************************************************************************/

#ifndef EQUALIZER_H
#define EQUALIZER_H

#include "includes.h"

#define EQ_COMMON_BANDS_COUNT 10
#define EQ_COMMON_NAME "equalizer-10bands"
#define EQ_INI_PRESETS_GROUP "eqPresets"

class Equalizer : public QObject
{
    Q_OBJECT
public:
    explicit Equalizer(QObject *parent = 0);
    ~Equalizer();
    
    static inline QString& getModuleName(){return moduleName;}
    static inline int getBandsCount(){return bandsCount;}
    static inline int getBandFrequency(int bandIndex){return bandFrequencies[bandIndex];}

    inline double getBandUpperBound(int bandIndex) const {return bandUpperBounds[bandIndex];}
    inline double getBandLowerBound(int bandIndex) const {return bandLowerBounds[bandIndex];}
    inline double getBandLevel(int bandIndex) const {return bandLevels[bandIndex];}
    double setBandLevel(int bandIndex, double newLevel);

    double setDefaultBandLevel(int bandIndex);
    void setDefaultLevels();
    double getRealBandLevel(int bandIndex);
    double updateLevel(int bandIndex);
    void updateLevels();

    inline Phonon::Effect* getEffect() {return effect;}

    inline void setPresetsIni(QSettings* presetsIni){ini = presetsIni;}
    inline const QSettings* getPresetsIni() const {return ini;}
    void saveToPreset(const QString& presetName);
    bool loadFromPreset(const QString& presetName);
    bool renamePreset(const QString& oldPresetName, const QString& newPresetName);
    bool copyPreset(const QString& srcPresetName, const QString& destPresetName);
    void deletePreset(const QString& presetName);
    QStringList getPresetsList();
    QStringList getValidPresetsList();
    bool isPresetExists(const QString& presetName);
    bool hasValidPreset(const QString& presetName);

protected:
    static QString moduleName;
    static int bandsCount;
    static int bandFrequencies[EQ_COMMON_BANDS_COUNT];
    static QString bandNames[EQ_COMMON_BANDS_COUNT];

    Phonon::Effect* effect;
    double bandUpperBounds[EQ_COMMON_BANDS_COUNT];
    double bandLowerBounds[EQ_COMMON_BANDS_COUNT];
    double bandLevels[EQ_COMMON_BANDS_COUNT];
    double bandDefaultLevels[EQ_COMMON_BANDS_COUNT];
    Phonon::EffectParameter bandFxParams[EQ_COMMON_BANDS_COUNT];
    QSettings* ini;

    Phonon::Effect* createEffect();
    void init();
    Phonon::EffectParameter getParamByName(const QString& paramName);
    QString getPresetIniKey(const QString& presetName);
    void saveArrayToPreset(const double* levels, const QString& presetName);
    bool loadArrayFromPreset(double* levels, const QString& presetName);
};

#endif // EQUALIZER_H
