/*************************************************************************}
{ qwidgethelper.cpp - some convenience widget functions                   }
{                                                                         }
{ (c) Alexey Parfenov, 2012                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This library is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This library is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 21 Mar 2012                                              }
{*************************************************************************/

#include "qwidgethelper.h"

void QWidgetHelper::setupDefaults()
{
    QWidget* thisWidget = (QWidget*)this;

    QWidget* parent = qobject_cast<QWidget*>(thisWidget->parent());
    QFont f;
    if(parent)
    {
        f = parent->font();
        thisWidget->setLocale(parent->locale());
    }
    else
    {
        f = thisWidget->font();
        f.setPointSize(8);
        f.setFamily("Arial");
    }
    thisWidget->setFont(f);
    thisWidget->setContextMenuPolicy(Qt::NoContextMenu);
    thisWidget->setMouseTracking(true);
}

void QWidgetHelper::fullyActivate()
{
    QWidget* thisWidget = (QWidget*)this;

    thisWidget->show();
    thisWidget->raise();
    thisWidget->activateWindow();
    thisWidget->setFocus();
}

void QWidgetHelper::setScreenOrientation(ScreenOrientation orientation)
{
    QWidget* thisWidget = (QWidget*)this;

#if defined(Q_OS_SYMBIAN)
    // If the version of Qt on the device is < 4.7.2, that attribute won't work
    if (orientation != ScreenOrientationAuto) {
        const QStringList v = QString::fromAscii(qVersion()).split(QLatin1Char('.'));
        if (v.count() == 3 && (v.at(0).toInt() << 16 | v.at(1).toInt() << 8 | v.at(2).toInt()) < 0x040702) {
            qWarning("Screen orientation locking only supported with Qt 4.7.2 and above");
            return;
        }
    }
#endif // Q_OS_SYMBIAN

    Qt::WidgetAttribute attribute;

#if QT_VERSION < 0x040702
        const Qt::WidgetAttribute attrLockPortrtait = static_cast<Qt::WidgetAttribute>(128);
        const Qt::WidgetAttribute attrLockLandscape = static_cast<Qt::WidgetAttribute>(129);
        const Qt::WidgetAttribute attrAuto = static_cast<Qt::WidgetAttribute>(130);
#else // QT_VERSION < 0x040702
        const Qt::WidgetAttribute attrLockPortrtait = Qt::WA_LockPortraitOrientation;
        const Qt::WidgetAttribute attrLockLandscape = Qt::WA_LockLandscapeOrientation;
        const Qt::WidgetAttribute attrAuto = Qt::WA_AutoOrientation;
#endif // QT_VERSION < 0x040702

    switch (orientation)
    {
        case ScreenOrientationLockPortrait:
            attribute = attrLockPortrtait;
            break;

        case ScreenOrientationLockLandscape:
            attribute = attrLockLandscape;
            break;

        default:
            attribute = attrAuto;
    }

    thisWidget->setAttribute(attrLockPortrtait, false);
    thisWidget->setAttribute(attrLockLandscape, false);
    thisWidget->setAttribute(attrAuto, false);
    thisWidget->setAttribute(attribute, true);
}

void QWidgetHelper::showExpanded()
{
    QWidget* thisWidget = (QWidget*)this;

#ifdef Q_OS_SYMBIAN
    thisWidget->showFullScreen();
#elif defined(Q_WS_MAEMO_5)
    thisWidget->showMaximized();
#else
    thisWidget->show();
#endif
}

