#!/usr/bin/python
# -*- coding: utf-8 -*-

import pygame
from pygame.locals import *
from random import choice, random, sample
import time

class FruitMathsGame(object):
    def __init__(self, reactor):
        self.reactor = reactor
        # Game specific properties
        types = sample(range(1,8), 3)
        self.gems = []
        for i in xrange(3):
            self.gems.append([Gem(self.reactor, types[i]), choice(range(1,10))])
        #~ self.operators = ["+", "-", "x"] # multiplication is really hard...
        self.operators = ["+", "-"]
        self.step = 0
        self.initial = True
        self.offset = self.gems[0][0].gem.get_width()/2
        offset = self.offset
        w = self.reactor.screen.get_width()/2-offset
        h = self.reactor.screen.get_height()
        vCenter = h/2
        vTot = h-40
        w = self.reactor.screen.get_width()
        hHalf = w/2
        self.lCenter = (((hHalf)-150)/2)+150
        self.rCenter = (hHalf)+(hHalf-150)/2
        self.positions1 = [(self.lCenter+50-offset, h/4-offset),
                           (self.lCenter+50-offset, 2*h/4-offset),
                           (self.lCenter+50-offset, 3*h/4-offset),
                           (self.lCenter+50, 3*h/8),
                           (self.lCenter+50, 5*h/8)]
        self.positions2 = [(self.rCenter-50-offset, h/4-offset),
                           (self.rCenter-50-offset, 2*h/4-offset),
                           (self.rCenter-50-offset, 3*h/4-offset),
                           (self.rCenter-50, 3*h/8),
                           (self.rCenter-50, 5*h/8)]
        self.Textpositions1 = [(self.lCenter-30, h/4),
                               (self.lCenter-30, 2*h/4),
                               (self.lCenter-30, 3*h/4)]
        self.Textpositions2 = [(self.rCenter+30, h/4),
                               (self.rCenter+30, 2*h/4),
                               (self.rCenter+30, 3*h/4)]
        self.wrong = True
        self.shownResult = 0
        self.result = "a bit early"
        # Universal Properties
        self.task ="Hit it when the fruit equation is correct"
    
    def play(self):
        if self.initial:
            self.step = 150
            self.initial = False
            for i in xrange(3):
                gem = pygame.transform.rotozoom(self.gems[i][0].gem, -90, 1)
                self.reactor.screen.blit(gem, self.positions1[i])
                gem = pygame.transform.rotozoom(self.gems[i][0].gem, 90, 1)
                self.reactor.screen.blit(gem, self.positions2[i])
                self.reactor.drawText(str(self.gems[i][1]),
                                      self.Textpositions1[i],
                                      300, "left", size=60)
                self.reactor.drawText(str(self.gems[i][1]),
                                      self.Textpositions2[i],
                                      300, "right", size=60)
        if self.step == 0:
            self.step = 200
            self.reactor.clearPlayArea()
            o1, o2, gems, self.result = self.generate_equation()
            for i in xrange(3):
                gem = pygame.transform.rotozoom(gems[i].gem, -90, 1)
                self.reactor.screen.blit(gem, self.positions1[i])
                gem = pygame.transform.rotozoom(gems[i].gem, 90, 1)
                self.reactor.screen.blit(gem, self.positions2[i])
            self.reactor.drawText(o1, self.positions1[3],
                                  300, "left", size=60)
            self.reactor.drawText(o2, self.positions1[4],
                                  300, "left", size=60)
            self.reactor.drawText(o1, self.positions2[4],
                                  300, "right", size=60)
            self.reactor.drawText(o2, self.positions2[3],
                                  300, "right", size=60)
            self.wrong = False
            self.shownResult = self.result
            if random() > 0.5:
                self.wrong = True
                if random() > 0.5:
                    self.shownResult = self.result + choice(range(1,5))
                else:
                    self.shownResult = self.result + choice(range(1,5))
            self.reactor.drawText("= " + str(self.shownResult), self.Textpositions1[1],
                                  300, "left", size=60)
            self.reactor.drawText("= " + str(self.shownResult), self.Textpositions2[1],
                                  300, "right", size=60)
        else:
            self.step = self.step - 1

    def generate_equation(self):
        o1 = choice(self.operators)
        o2 = choice(self.operators)
        n1 = choice(self.gems)
        n2 = choice(self.gems)
        n3 = choice(self.gems)
        if (o1 != "x") and (o2 == "x"):
            result = n3[1]
            result = self.operate(result, n2[1], o2)
            result = self.operate(n1[1], result, o1)
        else:
            result = n1[1]
            result = self.operate(result, n2[1], o1)
            result = self.operate(result, n3[1], o2)
        return o1, o2, [n1[0], n2[0], n3[0]], result
    
    def operate(self, n1, n2, operator):
        if operator == "+":
            return n1 + n2
        elif operator == "-":
            return n1 - n2
        elif operator == "x":
            return n1 * n2
    
    def evaluate(self, player):
        correct = (self.shownResult == self.result)
        if correct:
            self.winMessage = "Sweet!"
            self.loseMessage = "Bitter!"
            if player == 1: return 1
            if player == 2: return 2
        else:
            self.winMessage = "You win!"
            self.loseMessage = "It's actually " + str(self.result)
            if player == 1: return 2
            if player == 2: return 1
            
class Gem(object):
    def __init__(self, reactor, type):
        self.reactor = reactor
        self.gem, self.gemRect = self.reactor.load_image(
                                 'fruit0' + str(type) + '.png', -1)
        self.gem = pygame.transform.rotozoom(self.gem, 0, 0.6)
        
    def __eq__(o1, o2):
        if o1.type == o2.type:
            return True
        else:
            return False
            
    def __hash__(self):
        return self.type
        
        
        
        
        
        
        
        
        
        
