/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 */
#include "utils.h"

#include <Qt>
#include <QtGui>
#include <QFile>
#include <QDesktopServices>
#include <QListView>
#include "AntiTheftOptionsDialog.h"
#include "eWallet.h"

AntiTheftOptionsDialog::AntiTheftOptionsDialog(QWidget *parent): QDialog(parent) {
	setWindowTitle("Wallet");

	setContextMenuPolicy(Qt::NoContextMenu);
	QHBoxLayout * layout = new QHBoxLayout(this);

	manager = new AntiTheftManager (this);

	layout->setMargin(0);
	layout->setSpacing(0);

	layout->setSpacing(10);
	layout->setMargin(10);

	QDialogButtonBox* dlgBtnBox = new QDialogButtonBox(this);
	dlgBtnBox->setOrientation(Qt::Vertical);

	finishSave = new QPushButton(tr("Save"), this);
//	//closeButton->setFixedHeight(70);
	finishSave->setContextMenuPolicy(Qt::NoContextMenu);
	finishSave->setFocusPolicy(Qt::NoFocus);
	finishSave->setIconSize(QSize(48, 48));
	QObject::connect(finishSave, SIGNAL(clicked()), this, SLOT(save()));
	dlgBtnBox->addButton(finishSave, QDialogButtonBox::ActionRole);

	QGridLayout * componentLayout = new QGridLayout ();
	componentLayout->setContentsMargins(15, 0, 15, 0);
	componentLayout->setSpacing(5);

	enable = new QCheckBox(tr("Enable Anti-Theft"), this);
	enable->setContextMenuPolicy(Qt::NoContextMenu);
	enable->setChecked(manager->isEnabled());
	QObject::connect(enable, SIGNAL(clicked()), this, SLOT(antitheftChanged()));
	componentLayout->addWidget(enable, 0, 0, 1, 1);

	QLabel * nameLabel;
	nameLabel = new QLabel(tr("Password"), this);
	nameLabel->setContextMenuPolicy(Qt::NoContextMenu);
	componentLayout->addWidget(nameLabel, 1, 0, 1, 1);

	password1 = new QLineEdit ("", this);
	password1->setContextMenuPolicy(Qt::NoContextMenu);
	password1->setEchoMode(QLineEdit::Password); //EchoOnEdit);
	password1->setInputMethodHints(Qt::ImhHiddenText | Qt::ImhNoAutoUppercase | Qt::ImhNoPredictiveText);
	password1->setMaxLength(16); //  |
	componentLayout->addWidget(password1, 1, 1, 1, 1);

	password2 = new QLineEdit ("", this);
	password2->setContextMenuPolicy(Qt::NoContextMenu);
	password2->setEchoMode(QLineEdit::Password); //EchoOnEdit);
	password2->setInputMethodHints(Qt::ImhHiddenText | Qt::ImhNoAutoUppercase | Qt::ImhNoPredictiveText);
	password2->setMaxLength(16); //  |
	componentLayout->addWidget(password2, 1, 2, 1, 1);

	nameLabel = new QLabel(tr("Emergency Phone"), this);
	nameLabel->setContextMenuPolicy(Qt::NoContextMenu);
	componentLayout->addWidget(nameLabel, 2, 0, 1, 1);

	phonenumber = new QLineEdit ("", this);
	phonenumber->setContextMenuPolicy(Qt::NoContextMenu);
	phonenumber->setInputMethodHints(Qt::ImhDigitsOnly);
	phonenumber->setMaxLength(16); //  |
	componentLayout->addWidget(phonenumber, 2, 1, 1, 2);

	nameLabel = new QLabel(tr("Emergency Email"), this);
	nameLabel->setContextMenuPolicy(Qt::NoContextMenu);
	componentLayout->addWidget(nameLabel, 3, 0, 1, 1);

	email = new QLineEdit ("", this);
	email->setContextMenuPolicy(Qt::NoContextMenu);
	email->setInputMethodHints(Qt::ImhEmailCharactersOnly);
	componentLayout->addWidget(email, 3, 1, 1, 2);

	layout->addLayout(componentLayout);
	layout->setAlignment(componentLayout, Qt::AlignVCenter);

	layout->addWidget(dlgBtnBox);
	layout->setAlignment(dlgBtnBox, Qt::AlignBottom);

	setLayout(layout);

	antitheftChanged ();
}

AntiTheftOptionsDialog::~AntiTheftOptionsDialog() {

}
void AntiTheftOptionsDialog::save () {
	if (enable->isChecked()) {
		if (password1->text().length() <= 0) {
#ifdef Q_WS_MAEMO_5
			show_banner (this, tr("Password is required"));
#else
			QPointer <QMessageBox> messageBox;
			if (messageBox.isNull()) {
				messageBox = new QMessageBox(this);
				messageBox->information(this, "Wallet", tr("Password is required"), QMessageBox::Ok);
			}
			delete messageBox;
			messageBox = 0;
#endif
			return;
		}
		if (password1->text() != password2->text()) {
#ifdef Q_WS_MAEMO_5
			show_banner (this, tr("Invalid password, please enter again"));
#else
			QPointer <QMessageBox> messageBox;
			if (messageBox.isNull()) {
				messageBox = new QMessageBox(this);
				messageBox->information(this, "Wallet", tr("Invalid password, please enter again"), QMessageBox::Ok);
			}
			delete messageBox;
			messageBox = 0;
#endif
			return;
		}


		manager->enable (password1->text(), phonenumber->text(), email->text());
	}
	else {

		manager->disable (password1->text());
	}

	done(QDialog::Accepted);
}

void AntiTheftOptionsDialog::antitheftChanged () {
	password1->setEnabled(enable->isChecked());
	password2->setEnabled(enable->isChecked());
	email->setEnabled(enable->isChecked());
	phonenumber->setEnabled(enable->isChecked());
}
