//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#ifndef LSPROFILE_H
#define LSPROFILE_H
#include "lsimage.h"
#include "backends/systemprofiles.h"

class LsProfile : public QObject, public LsImage
{
    Q_OBJECT
public:
    LsProfile(QString name="");

    void applySettings();
    void startUpdate();
    void stopUpdate();

private:
    QHash<QString, QString> m_Images;
    QString m_ProfileName;
    SystemProfiles* m_Profile;
    void getCurrentProfile();
    void setImage();

private slots:
    void profileChangedSlot(QString);
};

#endif // LSPROFILE_H
