//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "lsmediaplaypausebutton.h"

LsMediaPlayPauseButton::LsMediaPlayPauseButton(QString name, SystemPlayer* player) :
        LsButton(name.isEmpty() ? "MediaPlayPauseButton": name)
{
    m_Player = player;
    if (m_Player)
        m_PlayerState = player->state();
    else
        m_PlayerState = SystemPlayer::UnknownState;

    applySettings();
}

void LsMediaPlayPauseButton::applySettings()
{
    if (m_PlayerState == SystemPlayer::PlayingState){
        m_Bkg = QPixmap(getSetting("BackGroundImagePause", "/opt/qtlockscreen/default/pause.png").toString());
        m_BkgPressed = QPixmap(getSetting("BackGroundImagePausePressed", "/opt/qtlockscreen/default/pausePressed.png").toString());
    }else{
        m_Bkg = QPixmap(getSetting("BackGroundImagePlay", "/opt/qtlockscreen/default/play.png").toString());
        m_BkgPressed = QPixmap(getSetting("BackGroundImagePlayPressed", "/opt/qtlockscreen/default/playPressed.png").toString());
    }
    m_BkgPressed = m_BkgPressed.scaled(m_Bkg.size());
    setSizeAndPosition(m_Bkg.size(), QPoint(0, 0));
}

void LsMediaPlayPauseButton::clicked()
{
    qDebug() << "Button " << name() << "clicked";
    if (m_Player){
        if (m_PlayerState == SystemPlayer::PausedState)
            m_Player->resume();
        else if (m_PlayerState == SystemPlayer::PlayingState)
            m_Player->pause();
        else if (m_PlayerState == SystemPlayer::StoppedState || m_PlayerState == SystemPlayer::UnknownState)
            m_Player->play();
    }
}

void LsMediaPlayPauseButton::onPlayerStateChanged(SystemPlayer::PlaybackState state)
{
    if (state != m_PlayerState){
        m_PlayerState = state;
        applySettings();
        update();
    }
}

void LsMediaPlayPauseButton::stopUpdate()
{
    if (m_Player){
        disconnect(m_Player, SIGNAL(stateChanged(SystemPlayer::PlaybackState)), this, SLOT(onPlayerStateChanged(SystemPlayer::PlaybackState)));
    }
}

void LsMediaPlayPauseButton::startUpdate()
{
    if (m_Player){
        connect(m_Player, SIGNAL(stateChanged(SystemPlayer::PlaybackState)), this, SLOT(onPlayerStateChanged(SystemPlayer::PlaybackState)));
        onPlayerStateChanged(m_Player->state());
    }
}
