//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#ifndef LSBLUETOOTH_H
#define LSBLUETOOTH_H
#include "lsimage.h"

class LsBluetooth : public QObject, public LsImage
{
    Q_OBJECT
public:
    LsBluetooth(QString name="");

    void applySettings();
    void startUpdate();
    void stopUpdate();

private:
    bool m_IsOn;
    QString m_Adapter;
    QString m_On;
    QString m_Off;

    QString getAdapter();
    void getStatus();
    void setImage();

private slots:
#ifdef Q_WS_MAEMO_5
    void onPropertyChange(QDBusMessage);
#endif
};

#endif // LSBLUETOOTH_H
