#include <QLabel>
#include <QPushButton>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QLineEdit>
 #include <QRegExpValidator>

#include <QtNetwork/QTcpSocket>
#include <QtNetwork/QHostAddress>

#include "clientdialog.h"

ClientDialog::ClientDialog(QTcpSocket *gameClient, QWidget *parent) :
    QDialog(parent),
    gameClient_(gameClient)
{
    QVBoxLayout *topLayout = new QVBoxLayout(this);
    QLabel *lb = new QLabel(tr("Waiting black player (server)"), this);
    topLayout->addWidget(lb);
    lb = new QLabel(tr("Enter IP and port of server:"), this);
    topLayout->addWidget(lb);

    QHBoxLayout *addrLayout = new QHBoxLayout;
    lb = new QLabel(tr("IP:"), this);
    addrLayout->addWidget(lb);
    lnAddress_ = new QLineEdit(this);
    lnAddress_->setValidator(new QRegExpValidator(QRegExp("[0-9]{1,3}(.[0-9]{1,3}){3,3}"), this));
    addrLayout->addWidget(lnAddress_);
    lb = new QLabel(tr("Port:"), this);
    addrLayout->addWidget(lb);
    lnPort_ = new QLineEdit(this);
    lnPort_->setValidator(new QIntValidator(1, 65535, this));
    addrLayout->addWidget(lnPort_);
    topLayout->addItem(addrLayout);

    QHBoxLayout *buttonLayout = new QHBoxLayout;
    buttonLayout->addStretch(1);
    btConnect_ = new QPushButton(tr("C&onnect"), this);
    btConnect_->setAutoDefault(true);
    //btConnect_->setEnabled(false);
    buttonLayout->addWidget(btConnect_);
    QPushButton *btCancel = new QPushButton(tr("&Cancel"), this);
    buttonLayout->addWidget(btCancel);
    topLayout->addItem(buttonLayout);

    quint16 peerPort = gameClient_->peerPort();
    //connection already exists, so show info about it
    if (peerPort)
    {
        QString port("%1");
        lnPort_->setText(port.arg(peerPort));
        lnAddress_->setText(gameClient_->peerAddress().toString());
    }

    connect(btCancel, SIGNAL(pressed()), SLOT(reject()));
    connect(btConnect_, SIGNAL(pressed()), SLOT(slotConnect()));
}

void
ClientDialog::slotConnect()
{
    QString addr(lnAddress_->text()), port(lnPort_->text());
    if (gameClient_->peerAddress().toString() != addr || gameClient_->peerPort() != port.toInt())
    {
        gameClient_->abort();
        gameClient_->connectToHost(lnAddress_->text(), lnPort_->text().toInt());
    }
    accept();
}
