/****************************************************************************
**
** Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the Qt Mobility Components.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include "tst_qgeoroute.h"

QTM_USE_NAMESPACE

tst_QGeoRoute::tst_QGeoRoute()
{
}

void tst_QGeoRoute::initTestCase()
{

}

void tst_QGeoRoute::cleanupTestCase()
{

}

void tst_QGeoRoute::init()
{
    qgeoroute = new QGeoRoute();
    qgeocoordinate = new QGeoCoordinate ();
}

void tst_QGeoRoute::cleanup()
{
    delete qgeoroute;
    delete qgeocoordinate;
}

void tst_QGeoRoute::constructor()
{
    QString empty="";
    QGeoBoundingBox *boundingbox = new QGeoBoundingBox();

    QCOMPARE(qgeoroute->bounds(),*boundingbox);
    QCOMPARE(qgeoroute->distance(), qreal(0.0));
    QCOMPARE(qgeoroute->path().size(),0);
    QCOMPARE(qgeoroute->routeId(),empty);
    QCOMPARE(qgeoroute->travelTime(),0);

    delete boundingbox;
}

void tst_QGeoRoute::copy_constructor()
{
    QGeoRoute *qgeoroutecopy = new QGeoRoute (*qgeoroute);
    QCOMPARE(*qgeoroute,*qgeoroutecopy);
    delete qgeoroutecopy;
}

void tst_QGeoRoute::destructor()
{
    QGeoRoute *qgeoroutecopy;

    QLocationTestUtils::uheap_mark();
    qgeoroutecopy = new QGeoRoute();
    delete qgeoroutecopy;
    QLocationTestUtils::uheap_mark_end();

    QLocationTestUtils::uheap_mark();
    qgeoroutecopy = new QGeoRoute(*qgeoroute);
    delete qgeoroutecopy;
    QLocationTestUtils::uheap_mark_end();
}

void tst_QGeoRoute::bounds()
{
    qgeocoordinate->setLatitude(13.3851);
    qgeocoordinate->setLongitude(52.5312);

    QGeoBoundingBox *qgeoboundingbox= new QGeoBoundingBox(*qgeocoordinate,0.4,0.4);

    qgeoroute->setBounds(*qgeoboundingbox);

    QCOMPARE(qgeoroute->bounds(),*qgeoboundingbox);

    qgeoboundingbox->setWidth(23.1);

    QVERIFY(qgeoroute->bounds().width() != qgeoboundingbox->width());

    delete qgeoboundingbox;


}

void tst_QGeoRoute::distance()
{
    qreal distance = 0.0;

    qgeoroute->setDistance(distance);
    QCOMPARE(qgeoroute->distance(),distance);

    distance = 34.4324;
    QVERIFY(qgeoroute->distance() != distance);

    qgeoroute->setDistance(distance);
    QCOMPARE(qgeoroute->distance(),distance);
}

void tst_QGeoRoute::path()
{
    QFETCH(QList<double>, coordinates);

    QList<QGeoCoordinate> path;

    for (int i = 0; i<coordinates.size(); i=i+2)
    {

        path.append(*(new QGeoCoordinate(coordinates.at(i),coordinates.at(i+1))));
    }

   qgeoroute->setPath(path);

    QList<QGeoCoordinate> pathretrieved= qgeoroute->path();
    QCOMPARE(pathretrieved,path);

    for (int i=0; i<pathretrieved.size();i++)
    {
        QCOMPARE(pathretrieved.at(i),path.at(i));
    }
}

void tst_QGeoRoute::path_data()
{
    QTest::addColumn<QList<double> >("coordinates");

    QList<double> coordinates;

    coordinates << 0.0 << 0.0;
    QTest::newRow("path1") << coordinates ;

    coordinates << -23.23 << 54.45345;
    QTest::newRow("path2") << coordinates ;

    coordinates << -85.4324 << -121.343;
    QTest::newRow("path3") << coordinates ;

    coordinates << 1.323 << 12.323;
    QTest::newRow("path4") << coordinates ;

    coordinates << 1324.323 << 143242.323;
    QTest::newRow("path5") << coordinates ;
}
void tst_QGeoRoute::request()
{
    qgeocoordinate->setLatitude(65.654);
    qgeocoordinate->setLongitude(0.4324);

    QGeoCoordinate *qgeocoordinatecopy = new QGeoCoordinate (34.54 , -21.32);

    QList<QGeoCoordinate> path;
    path.append(*qgeocoordinate);
    path.append(*qgeocoordinatecopy);

    qgeorouterequest = new QGeoRouteRequest(path);

    qgeoroute->setRequest(*qgeorouterequest);

    QCOMPARE(qgeoroute->request(),*qgeorouterequest);

    QGeoCoordinate *qgeocoordinatecopy2 = new QGeoCoordinate (4.7854 , -121.32);
    path.append(*qgeocoordinatecopy2);

    QGeoRouteRequest *qgeorouterequestcopy = new QGeoRouteRequest(path);

    QVERIFY(qgeoroute->request() != *qgeorouterequestcopy);

    delete qgeocoordinatecopy;
    delete qgeocoordinatecopy2;
    delete qgeorouterequest;
    delete qgeorouterequestcopy;
}

void tst_QGeoRoute::routeId()
{
    QString text = "routeId 4504";

    qgeoroute->setRouteId(text);

    QCOMPARE (qgeoroute->routeId(),text);

    text="routeId 1111";
    QVERIFY (qgeoroute->routeId() != text);

}

void tst_QGeoRoute::firstrouteSegments()
{
    qgeoroutesegment = new QGeoRouteSegment ();
    qgeoroutesegment->setDistance(35.453);
    qgeoroutesegment->setTravelTime(56);

    qgeoroute->setFirstRouteSegment(*qgeoroutesegment);

    QCOMPARE(qgeoroute->firstRouteSegment(),*qgeoroutesegment);

    QGeoRouteSegment *qgeoroutesegmentcopy = new QGeoRouteSegment ();
    qgeoroutesegmentcopy->setDistance(435.432);
    qgeoroutesegmentcopy->setTravelTime(786);

    QVERIFY(qgeoroute->firstRouteSegment() != *qgeoroutesegmentcopy);

    delete qgeoroutesegment;
    delete qgeoroutesegmentcopy;

}

void tst_QGeoRoute::travelMode()
{
    QFETCH(QGeoRouteRequest::TravelMode,mode);

    qgeoroute->setTravelMode(mode);
    QCOMPARE(qgeoroute->travelMode(),mode);
}
void tst_QGeoRoute::travelMode_data()
{
    QTest::addColumn<QGeoRouteRequest::TravelMode>("mode");

    QTest::newRow("mode1") << QGeoRouteRequest::CarTravel;
    QTest::newRow("mode2") << QGeoRouteRequest::PedestrianTravel;
    QTest::newRow("mode3") << QGeoRouteRequest::BicycleTravel;
    QTest::newRow("mode4") << QGeoRouteRequest::PublicTransitTravel;
    QTest::newRow("mode5") << QGeoRouteRequest::TruckTravel;
}

void tst_QGeoRoute::travelTime()
{
    int time = 0;
    qgeoroute->setTravelTime(time);

    QCOMPARE (qgeoroute->travelTime(),time);

    time = 35;

    QVERIFY (qgeoroute->travelTime() != time);

    qgeoroute->setTravelTime(time);
    QCOMPARE (qgeoroute->travelTime(),time);
}

void tst_QGeoRoute::operators()
{
    QGeoRoute *qgeoroutecopy = new QGeoRoute (*qgeoroute);

    QVERIFY(qgeoroute->operator ==(*qgeoroutecopy));
    QVERIFY(!qgeoroute->operator !=(*qgeoroutecopy));

    qgeoroute->setDistance(543.324);
    qgeoroute->setRouteId("RouteId 111");
    qgeoroute->setTravelMode(QGeoRouteRequest::PedestrianTravel);
    qgeoroute->setTravelTime(10);

    qgeoroutecopy->setDistance(12.21);
    qgeoroutecopy->setRouteId("RouteId 666");
    qgeoroutecopy->setTravelMode(QGeoRouteRequest::BicycleTravel);
    qgeoroutecopy->setTravelTime(99);

// Not passing
//    QVERIFY(!(qgeoroute->operator ==(*qgeoroutecopy)));
// Not passing
//    QVERIFY(qgeoroute->operator !=(*qgeoroutecopy));

    *qgeoroutecopy = qgeoroutecopy->operator =(*qgeoroute);
    QVERIFY(qgeoroute->operator ==(*qgeoroutecopy));
    QVERIFY(!qgeoroute->operator !=(*qgeoroutecopy));

    delete qgeoroutecopy;
}



QTEST_MAIN(tst_QGeoRoute);
