#ifndef ARTISTCATALOGUE_H
#define ARTISTCATALOGUE_H
#include "trackcollection.h"
#include <QHash>

namespace Spotify
{
    class Artist;
    class Track;
    class Album;
    class ArtistCatalogue: public Spotify::TrackCollection
    {
        Q_OBJECT

        public:
            ArtistCatalogue( sp_artistbrowse* ab, QObject* parent = 0 );

            sp_artistbrowse* getArtistBrowse() const { return m_artistbrowse; }
            Spotify::Artist* getArtist() { return m_artist; }
            QList< const byte* > getPortraits() const { return m_portraits; }
            QList< Spotify::Artist* > getSimilarArtists() { return m_similarArtists; }
            QString getBiography() const { return m_biography; }
            QList<Spotify::Album*>* getAlbums() { return &m_AlbumList; }
            virtual bool load();
            virtual ~ArtistCatalogue();

        private:

            sp_artistbrowse* m_artistbrowse;
            Spotify::Artist* m_artist;
            QList< const byte* > m_portraits;
            QList< Spotify::Artist* > m_similarArtists;
            QString m_biography;

            QList<Spotify::Album*> m_AlbumList; //list of artist albums
    };

} // namespace Spotify

#endif // ARTISTCATALOGUE_H
