#include <QtGui/QApplication>
#include <QDBusError>
#include <QDBusConnection>
#include "mainwindow.h"

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);
   if (!QDBusConnection::sessionBus().isConnected()) {
    qWarning("Cannot connect to the D-Bus session bus.");
    exit(1);
}

if (!QDBusConnection::sessionBus().registerService("org.maemo.qspot")) 
{
    qWarning("%s", qPrintable(QDBusConnection::sessionBus().lastError().
        message()));
    exit(2);
}
MainWindow w;
if (!QDBusConnection::sessionBus().registerObject("/org/maemo/qspot", &w,QDBusConnection::ExportScriptableSlots)) 
{
    qWarning("%s", qPrintable(QDBusConnection::sessionBus().lastError().message()));
    exit(3);
}

#if defined(Q_WS_S60) || defined(Q_WS_MAEMO_5)
    w.showMaximized();
#else
    w.show();
#endif
    return a.exec();
}
