//AlbumView.h: Header file for the AlbumView class (display the details related to a particular album)

#ifndef ALBUMVIEW_H
#define ALBUMVIEW_H

#include <QDialog>
#include <QGridLayout>
#include <QVBoxLayout>
#include <QImage>
#include <QPixmap>
#include <QLabel>
#include <QFont>
#include <QFontMetrics>
#include <QPushButton>
#include <QListView>
#include <QModelIndex>
#include <QStandardItem>
#include <QStandardItemModel>
#include <QMaemo5InformationBox>
#include <qspotify_src/spotifysession.h>
#include <qspotify_src/imagecontainer.h>
#include <qspotify_src/album.h>
#include <qspotify_src/albumbrowser.h>
#include "ListViewDelegate.h"
#include "CustomTextDialog.h"

#define ALBUMVIEW_ID 2

#define ALBUMVIEW_COVERART_WIDTH    290
#define ALBUMVIEW_COVERART_HEIGHT   290

class AlbumView : public QDialog
{
    Q_OBJECT

public:

    AlbumView(Spotify::Session* pSession, QWidget* pParent = 0); //default constructor
    ~AlbumView(); //destructor

    void setAlbum(Spotify::Album* pAlbum); //set the album instance to be displayed

private:

    QGridLayout m_MainLayout; //main dialog layout

    QVBoxLayout m_LeftSubLayout; //left sub-layout, containing e.g., the coverart and artist name

    QLabel m_AlbumCover; //container label for the album coverart

    QLabel m_AlbumCaption; //caption of the currently displayed album

    QPushButton m_ArtistViewBtn; //button for showing the associated Artist View

    QPushButton m_AlbumReviewBtn; //album review button

    QListView* m_pAlbumTrackView; //list view containing the album tracks

    QStandardItemModel* m_pAlbumTrackModel; //model associated with the album tracks view

    CCustomTextDialog m_AlbumReviewDlg; //Album review dialog instance

    ListViewDelegate *m_pAlbumTrackDelegate; //delegate responsible for drawing the individual album track view items

    Spotify::Session* m_pSession; //Spotify session instance pointer

    Spotify::ImageContainer* m_pAlbumCoverContainer; //container instance for the coverart image

    Spotify::AlbumBrowser* m_pAlbumBrowser; //albumbrowser instance pointer

    qint32 m_CallerID; //passed as identifier to Spotify session methods that require caller ID

    void addTracks(); //add tracks to listview

    void setPlayQueue(); //assign playqueue

private slots:

    void OnAlbumBrowserReady(Spotify::AlbumBrowser* browser, qint32 callerID);
    void OnAlbumCoverLoaded();
    void OnTrackActivated(QModelIndex trackIndex);
    void OnAlbumReviewBtn();

signals:

    void playQueueSet(const QList<Spotify::Track*>&); //signal emitted when user selects track from album list, and new play queue is
                                                      //set

};

#endif // ALBUMVIEW_H
