#include "wbend.h"
#include "ui_wbend.h"

#include <QtCore/QCoreApplication>
#include <QShortcut>


Wbend::Wbend(QWidget *parent):
    QDialog(parent),
       ui(new Ui::Wbend)

{
    ui->setupUi(this);

    this->setWindowTitle(tr("Bends"));
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(Qt::Window);

    ui->pushButtonKalpineBend->setText(tr("Alpine Butterfly Bend"));
    ui->pushButtonKdoubleFB->setText(tr("Double Fisherman's Bend"));
    ui->pushButtonKsheetBend->setText(tr("Sheet Bend"));
    ui->pushButtonKzeppelin->setText(tr("Zeppelin Bend"));


    // For Connecting Keyboard Buttons
      connectSignals();
}

Wbend::~Wbend()
{
    delete ui;
}

// Keyboard Button Signals - remember to include QShortcut
void Wbend::connectSignals()
{

// Keyboard Key Signals

   connect(new QShortcut(QKeySequence(Qt::Key_Backspace), this), SIGNAL(activated()), this, SLOT(close()));
  connect(new QShortcut(QKeySequence(Qt::Key_Q), this), SIGNAL(activated()), this, SLOT(on_pushButtonKalpineBend_pressed()));
  connect(new QShortcut(QKeySequence(Qt::Key_W), this), SIGNAL(activated()), this, SLOT(on_pushButtonKdoubleFB_pressed()));
  connect(new QShortcut(QKeySequence(Qt::Key_E), this), SIGNAL(activated()), this, SLOT(on_pushButtonKsheetBend_pressed()));
  connect(new QShortcut(QKeySequence(Qt::Key_R), this), SIGNAL(activated()), this, SLOT(on_pushButtonKzeppelin_pressed()));
}

// End of Keyboard Signals

//Buttons

void Wbend::on_pushButtonKalpineBend_pressed()
{
    KalpineBend *kalpinebend = new KalpineBend(this);
    kalpinebend->exec();
}

void Wbend::on_pushButtonKdoubleFB_pressed()
{
    KdoubleFB *kdoublefb = new KdoubleFB(this);
    kdoublefb->exec();
}

void Wbend::on_pushButtonKsheetBend_pressed()
{
    KsheetBend *ksheetbend = new KsheetBend(this);
    ksheetbend->exec();
}

void Wbend::on_pushButtonKzeppelin_pressed()
{
    Kzeppelin *kzeppelin = new Kzeppelin(this);
    kzeppelin->exec();
}
