#include "lsquare.h"
#include "ui_lsquare.h"

#include <QtCore/QCoreApplication>
#include <QShortcut>

Lsquare::Lsquare(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Lsquare)
{
    ui->setupUi(this);

    //Set Window
    this->setWindowTitle(tr("Square Lashing"));
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(Qt::Window);

    //Set Image
    imgScene = new QGraphicsScene(ui->img);
    QGraphicsPixmapItem *item;
    QPixmap mImg("/opt/qnotted/images/lsquare.jpg");
    ui->img->setScene(imgScene);
    mImg = mImg.scaled(QSize(180, 180), Qt::KeepAspectRatio);
    item = new QGraphicsPixmapItem(mImg);
    imgScene->addItem(item);


    //Set Large Image
    imgSceneLarge = new QGraphicsScene(ui->imgLarge);
    QGraphicsPixmapItem *itemLarge;
    QPixmap mImgLarge("/opt/qnotted/images/lsquare.jpg");
    ui->imgLarge->setScene(imgSceneLarge);
    mImgLarge = mImgLarge.scaled(QSize(440, 440), Qt::KeepAspectRatio);
    itemLarge = new QGraphicsPixmapItem(mImgLarge);
    imgSceneLarge->addItem(itemLarge);

    //Button Text
    ui->pushButton_Up->setText("");
    ui->pushButton_Down->setText("");
    ui->pushButton_Reset->setText("");


    // Set Button Icons
    ui->pushButton_Up->setIcon(QPixmap("/opt/qnotted/icons/br_up_icon&48.png"));
    ui->pushButton_Down->setIcon(QPixmap("/opt/qnotted/icons/br_down_icon&48.png"));
    ui->pushButton_Reset->setIcon(QPixmap("/opt/qnotted/icons/dash.png"));

    //Hide On Draw
    ui->pushButton_Reset->hide();
    ui->imgLarge->hide();

    //Set Text
    ui->textBrowser->setText(tr("\
        <b><u>Square Lashing</u></b> <br> \
        Start with the poles to be lashed crossing each other at right angles. <br> \
        Tie a Clove Hitch around the open end of the lowest pole. <br> \
        Wrap the poles together in a square working around over the higher pole and under the lowest. <br> \
        Keeping the turns neat is important, work outwards on the higher turns and inwards on the lower turns <br> \
        This ensures as much rope as possible is in contact with the pole. <br> \
        Frap the lashing with turns between the poles, finishing with a Clove Hitch adjacent the initial hitch to secure the end. <br> \
        <b>Notes</b> <br> \
        About 3-5 wrapping and frapping turns should be sufficient to form a secure lashing. <br> \
        Square Lashing's are best used where the poles cross each other at right angles. <br> \
        If the poles don't' cross at right angles the Diagonal Lashing is more secure. \
                                "));

    // For Connecting Keyboard Buttons
              connectSignals();
}

Lsquare::~Lsquare()
{
    delete ui;
}

// Keyboard Button Signals - remember to include QShortcut
void Lsquare::connectSignals()
{

// Keyboard Key Signals

        connect(new QShortcut(QKeySequence(Qt::Key_Backspace), this), SIGNAL(activated()), this, SLOT(close()));
     connect(new QShortcut(QKeySequence(Qt::Key_Up), this), SIGNAL(activated()), this, SLOT(on_pushButton_Up_pressed()));
     connect(new QShortcut(QKeySequence(Qt::Key_Down), this), SIGNAL(activated()), this, SLOT(on_pushButton_Down_pressed()));
     connect(new QShortcut(QKeySequence(Qt::Key_Space), this), SIGNAL(activated()), this, SLOT(on_pushButton_Reset_pressed()));
}

// End of Keyboard Signals


//Push Buttons

void Lsquare::on_pushButton_Up_pressed()
{
    ui->img->hide();
    ui->imgLarge->hide();
    ui->textBrowser->show();
    ui->pushButton_Up->hide();
    ui->pushButton_Down->show();
    ui->pushButton_Reset->show();
}

void Lsquare::on_pushButton_Reset_pressed()
{
    ui->img->show();
    ui->imgLarge->hide();
    ui->textBrowser->show();
    ui->pushButton_Up->show();
    ui->pushButton_Down->show();
    ui->pushButton_Reset->hide();
}

void Lsquare::on_pushButton_Down_pressed()
{
    ui->img->hide();
    ui->imgLarge->show();
    ui->textBrowser->hide();
    ui->pushButton_Up->show();
    ui->pushButton_Down->hide();
    ui->pushButton_Reset->show();
}
