#include "kbunny.h"
#include "ui_kbunny.h"

#include <QtCore/QCoreApplication>
#include <QShortcut>

Kbunny::Kbunny(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Kbunny)
{
    ui->setupUi(this);

    //Set Window
    this->setWindowTitle(tr("Double Figure 8 Loop"));
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(Qt::Window);

    //Set Image
    imgScene = new QGraphicsScene(ui->img);
    QGraphicsPixmapItem *item;
    QPixmap mImg("/opt/qnotted/images/kbunny.jpg");
    ui->img->setScene(imgScene);
    mImg = mImg.scaled(QSize(180, 180), Qt::KeepAspectRatio);
    item = new QGraphicsPixmapItem(mImg);
    imgScene->addItem(item);

    //Set Large Image
    imgSceneLarge = new QGraphicsScene(ui->imgLarge);
    QGraphicsPixmapItem *itemLarge;
    QPixmap mImgLarge("/opt/qnotted/images/kbunny.jpg");
    ui->imgLarge->setScene(imgSceneLarge);
    mImgLarge = mImgLarge.scaled(QSize(440, 440), Qt::KeepAspectRatio);
    itemLarge = new QGraphicsPixmapItem(mImgLarge);
    imgSceneLarge->addItem(itemLarge);

    //Button Text
    ui->pushButton_Up->setText("");
    ui->pushButton_Down->setText("");
    ui->pushButton_Reset->setText("");


    // Set Button Icons
    ui->pushButton_Up->setIcon(QPixmap("/opt/qnotted/icons/br_up_icon&48.png"));
    ui->pushButton_Down->setIcon(QPixmap("/opt/qnotted/icons/br_down_icon&48.png"));
    ui->pushButton_Reset->setIcon(QPixmap("/opt/qnotted/icons/dash.png"));

    //Hide On Draw
    ui->pushButton_Reset->hide();
    ui->imgLarge->hide();

    //Set Text
    ui->textBrowser->setText(tr("\
        <b><u>Double Figure 8 Loop ('Bunny Ears')</u></b> <br> \
        Using a long bight in the end of a rope proceed to tie a Figure 8 Knot. <br> \
        Instead of passing the bight through to complete a Figure 8 Loop, fold this bight and tuck that through the elbow. <br> \
        You should now have a knot resembling a Figure 8, with a single bight sticking out the side adjacent the standing end. <br> \
        Take this single bight open it and take it around over the whole knot so it finally ends up sitting against the Figure 8 on top of the standing end. <br> \
        <b><u>Notes</b> <br> \
        This is an important climbing knot normally used to equally split the load between two anchors. <br> \
        The loops will not slip or become unequal, it's also easy to untie after being loaded. <br> \
                                "));

    // For Connecting Keyboard Buttons
              connectSignals();
}

Kbunny::~Kbunny()
{
    delete ui;
}

// Keyboard Button Signals - remember to include QShortcut
void Kbunny::connectSignals()
{

// Keyboard Key Signals

        connect(new QShortcut(QKeySequence(Qt::Key_Backspace), this), SIGNAL(activated()), this, SLOT(close()));
     connect(new QShortcut(QKeySequence(Qt::Key_Up), this), SIGNAL(activated()), this, SLOT(on_pushButton_Up_pressed()));
     connect(new QShortcut(QKeySequence(Qt::Key_Down), this), SIGNAL(activated()), this, SLOT(on_pushButton_Down_pressed()));
     connect(new QShortcut(QKeySequence(Qt::Key_Space), this), SIGNAL(activated()), this, SLOT(on_pushButton_Reset_pressed()));
}

// End of Keyboard Signals


//Push Buttons

void Kbunny::on_pushButton_Up_pressed()
{
    ui->img->hide();
    ui->imgLarge->hide();
    ui->textBrowser->show();
    ui->pushButton_Up->hide();
    ui->pushButton_Down->show();
    ui->pushButton_Reset->show();
}

void Kbunny::on_pushButton_Reset_pressed()
{
    ui->img->show();
    ui->imgLarge->hide();
    ui->textBrowser->show();
    ui->pushButton_Up->show();
    ui->pushButton_Down->show();
    ui->pushButton_Reset->hide();
}

void Kbunny::on_pushButton_Down_pressed()
{
    ui->img->hide();
    ui->imgLarge->show();
    ui->textBrowser->hide();
    ui->pushButton_Up->show();
    ui->pushButton_Down->hide();
    ui->pushButton_Reset->show();
}
