#include "wend.h"
#include "ui_wend.h"

#include <QtCore/QCoreApplication>
#include <QShortcut>

Wend::Wend(QWidget *parent):
    QDialog(parent),
       ui(new Ui::Wend)

{
    ui->setupUi(this);

    this->setWindowTitle(tr("End Loops"));
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(Qt::Window);

    ui->pushButtonKbowline->setText(tr("Bowline"));
    ui->pushButtonKpoachers->setText(tr("Poacher's Knot"));
    ui->pushButtonKrunningB->setText(tr("Running Bowline"));
    ui->pushButtonKwaterB->setText(tr("Water Bowline"));

    // For Connecting Keyboard Buttons
      connectSignals();

}

Wend::~Wend()
{
    delete ui;
}

// Keyboard Button Signals - remember to include QShortcut
void Wend::connectSignals()
{

// Keyboard Key Signals

   connect(new QShortcut(QKeySequence(Qt::Key_Backspace), this), SIGNAL(activated()), this, SLOT(close()));
  connect(new QShortcut(QKeySequence(Qt::Key_Q), this), SIGNAL(activated()), this, SLOT(on_pushButtonKbowline_pressed()));
  connect(new QShortcut(QKeySequence(Qt::Key_W), this), SIGNAL(activated()), this, SLOT(on_pushButtonKpoachers_pressed()));
  connect(new QShortcut(QKeySequence(Qt::Key_E), this), SIGNAL(activated()), this, SLOT(on_pushButtonKrunningB_pressed()));
  connect(new QShortcut(QKeySequence(Qt::Key_R), this), SIGNAL(activated()), this, SLOT(on_pushButtonKwaterB_pressed()));
}

// End of Keyboard Signals

//Buttons

void Wend::on_pushButtonKbowline_pressed()
{
    Kbowline *kbowline = new Kbowline(this);
    kbowline->show();
}

void Wend::on_pushButtonKpoachers_pressed()
{
    Kpoachers *kpoachers = new Kpoachers(this);
    kpoachers->show();
}

void Wend::on_pushButtonKrunningB_pressed()
{
    KrunningB *krunningB = new KrunningB(this);
    krunningB->show();
}

void Wend::on_pushButtonKwaterB_pressed()
{
    KwaterB *kwaterB = new KwaterB(this);
    kwaterB->show();
}
