#include "ktumble.h"
#include "ui_ktumble.h"

#include <QtCore/QCoreApplication>
#include <QShortcut>

Ktumble::Ktumble(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Ktumble)
{
    ui->setupUi(this);

    //Set Window
    this->setWindowTitle(tr("Tumble Hitch"));
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(Qt::Window);

    //Set Image
    imgScene = new QGraphicsScene(ui->img);
    QGraphicsPixmapItem *item;
    QPixmap mImg("/opt/qnotted/images/ktumble.jpg");
    ui->img->setScene(imgScene);
    mImg = mImg.scaled(QSize(180, 180), Qt::KeepAspectRatio);
    item = new QGraphicsPixmapItem(mImg);
    imgScene->addItem(item);

    //Set Large Image
    imgSceneLarge = new QGraphicsScene(ui->imgLarge);
    QGraphicsPixmapItem *itemLarge;
    QPixmap mImgLarge("/opt/qnotted/images/ktumble.jpg");
    ui->imgLarge->setScene(imgSceneLarge);
    mImgLarge = mImgLarge.scaled(QSize(440, 440), Qt::KeepAspectRatio);
    itemLarge = new QGraphicsPixmapItem(mImgLarge);
    imgSceneLarge->addItem(itemLarge);

    //Button Text
    ui->pushButton_Up->setText("");
    ui->pushButton_Down->setText("");
    ui->pushButton_Reset->setText("");


    // Set Button Icons
    ui->pushButton_Up->setIcon(QPixmap("/opt/qnotted/icons/br_up_icon&48.png"));
    ui->pushButton_Down->setIcon(QPixmap("/opt/qnotted/icons/br_down_icon&48.png"));
    ui->pushButton_Reset->setIcon(QPixmap("/opt/qnotted/icons/dash.png"));

    //Hide On Draw
    ui->pushButton_Reset->hide();
    ui->imgLarge->hide();


    //Set Text
    ui->textBrowser->setText(tr("\
        <b><u>Tumble Hitch</u></b> <br> \
        Hold an initial bight of the rope against the object. <br> \
        Make a second bight in the working end and pass this behind the object then through the initial bight, so the working end is laying adjacent the standing end. <br> \
        Pass the working end around the front of the Standing End then behind the object and pass a bight of this through the second bight. <br> \
        Pull on the standing end to tighten and form the knot. <br> \
        Check the knot is tied correctly. You should have three stacked bights above the object and one bight around the standing end below the object. <br> \
        The standing end is now secure, pulling the working end will release the knot. <br> \
        <b>Important</b> <br> \
        This is a stable quick release hitch and is recommended in place of a Mooring or Highwayman's Hitch <br> \
        However, as with all quick release hitches accidential triggering of the release is possible, so is not for critical loads. <br> \
        The benefit of the Tumble Hitch is due to it's structure the final bight can be lengthened \
        and tied to the standing end to lock the release.<br> \
                                "));

    // For Connecting Keyboard Buttons
              connectSignals();
}

Ktumble::~Ktumble()
{
    delete ui;
}

// Keyboard Button Signals - remember to include QShortcut
void Ktumble::connectSignals()
{

// Keyboard Key Signals

        connect(new QShortcut(QKeySequence(Qt::Key_Backspace), this), SIGNAL(activated()), this, SLOT(close()));
     connect(new QShortcut(QKeySequence(Qt::Key_Up), this), SIGNAL(activated()), this, SLOT(on_pushButton_Up_pressed()));
     connect(new QShortcut(QKeySequence(Qt::Key_Down), this), SIGNAL(activated()), this, SLOT(on_pushButton_Down_pressed()));
     connect(new QShortcut(QKeySequence(Qt::Key_Space), this), SIGNAL(activated()), this, SLOT(on_pushButton_Reset_pressed()));
}

// End of Keyboard Signals


//Push Buttons

void Ktumble::on_pushButton_Up_pressed()
{
    ui->img->hide();
    ui->imgLarge->hide();
    ui->textBrowser->show();
    ui->pushButton_Up->hide();
    ui->pushButton_Down->show();
    ui->pushButton_Reset->show();
}

void Ktumble::on_pushButton_Reset_pressed()
{
    ui->img->show();
    ui->imgLarge->hide();
    ui->textBrowser->show();
    ui->pushButton_Up->show();
    ui->pushButton_Down->show();
    ui->pushButton_Reset->hide();
}

void Ktumble::on_pushButton_Down_pressed()
{
    ui->img->hide();
    ui->imgLarge->show();
    ui->textBrowser->hide();
    ui->pushButton_Up->show();
    ui->pushButton_Down->hide();
    ui->pushButton_Reset->show();
}
