#include "ktimber.h"
#include "ui_ktimber.h"

#include <QtCore/QCoreApplication>
#include <QShortcut>

Ktimber::Ktimber(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Ktimber)
{
    ui->setupUi(this);

    //Set Window
    this->setWindowTitle(tr("Timber Hitch"));
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(Qt::Window);

    //Set Image
    imgScene = new QGraphicsScene(ui->img);
    QGraphicsPixmapItem *item;
    QPixmap mImg("/opt/qnotted/images/ktimber.jpg");
    ui->img->setScene(imgScene);
    mImg = mImg.scaled(QSize(180, 180), Qt::KeepAspectRatio);
    item = new QGraphicsPixmapItem(mImg);
    imgScene->addItem(item);

    //Set Large Image
    imgSceneLarge = new QGraphicsScene(ui->imgLarge);
    QGraphicsPixmapItem *itemLarge;
    QPixmap mImgLarge("/opt/qnotted/images/ktimber.jpg");
    ui->imgLarge->setScene(imgSceneLarge);
    mImgLarge = mImgLarge.scaled(QSize(440, 440), Qt::KeepAspectRatio);
    itemLarge = new QGraphicsPixmapItem(mImgLarge);
    imgSceneLarge->addItem(itemLarge);

    //Button Text
    ui->pushButton_Up->setText("");
    ui->pushButton_Down->setText("");
    ui->pushButton_Reset->setText("");


    // Set Button Icons
    ui->pushButton_Up->setIcon(QPixmap("/opt/qnotted/icons/br_up_icon&48.png"));
    ui->pushButton_Down->setIcon(QPixmap("/opt/qnotted/icons/br_down_icon&48.png"));
    ui->pushButton_Reset->setIcon(QPixmap("/opt/qnotted/icons/dash.png"));

    //Hide On Draw
    ui->pushButton_Reset->hide();
    ui->imgLarge->hide();


    //Set Text
    ui->textBrowser->setText(tr("\
        <b><u>Timber Hitch</u></b> <br> \
        With the end of the rope make a turn around the object followed by a turn around the standing end. <br> \
        Pass the tail through the loop formed around the pole. <br> \
        Continue to pass the working end of the rope through and around the loop at least three times. <br> \
        Tighten the knot so that the turns grip against the object. <br> \
        <b>Important</b> <br> \
        This hitch should be used as a quick non-critical load hitch, ideal on rough objects like logs. <br> \
        The knot is easy to tie and falls apart easily when not under load. <br> \
        It is also the knot used on bow strings and some string instruments. <br> \
                                "));

    // For Connecting Keyboard Buttons
              connectSignals();
}

Ktimber::~Ktimber()
{
    delete ui;
}

// Keyboard Button Signals - remember to include QShortcut
void Ktimber::connectSignals()
{

// Keyboard Key Signals

        connect(new QShortcut(QKeySequence(Qt::Key_Backspace), this), SIGNAL(activated()), this, SLOT(close()));
     connect(new QShortcut(QKeySequence(Qt::Key_Up), this), SIGNAL(activated()), this, SLOT(on_pushButton_Up_pressed()));
     connect(new QShortcut(QKeySequence(Qt::Key_Down), this), SIGNAL(activated()), this, SLOT(on_pushButton_Down_pressed()));
     connect(new QShortcut(QKeySequence(Qt::Key_Space), this), SIGNAL(activated()), this, SLOT(on_pushButton_Reset_pressed()));
}

// End of Keyboard Signals


//Push Buttons

void Ktimber::on_pushButton_Up_pressed()
{
    ui->img->hide();
    ui->imgLarge->hide();
    ui->textBrowser->show();
    ui->pushButton_Up->hide();
    ui->pushButton_Down->show();
    ui->pushButton_Reset->show();
}

void Ktimber::on_pushButton_Reset_pressed()
{
    ui->img->show();
    ui->imgLarge->hide();
    ui->textBrowser->show();
    ui->pushButton_Up->show();
    ui->pushButton_Down->show();
    ui->pushButton_Reset->hide();
}

void Ktimber::on_pushButton_Down_pressed()
{
    ui->img->hide();
    ui->imgLarge->show();
    ui->textBrowser->hide();
    ui->pushButton_Up->show();
    ui->pushButton_Down->hide();
    ui->pushButton_Reset->show();
}
