import QtQuick 1.0

Row {
    id: root

    property int count
    property double ratingValue
    property int maximumValue

    height: 20
    spacing: 5

    Repeater {
        id: repeater

        model: maximumValue

        Image {
            width: parent.height
            height: parent.height
            source: (ratingValue < 1) || (index > ratingValue) ? !theme.inverted ? "../images/favourite.png" : "../images/favourite-white.png" : "../images/favourite-" + Settings.activeColorString + ".png"
            smooth: true
        }
    }

    Label {
        font.pixelSize: _SMALL_FONT_SIZE
        
        text: "(" + count + ")"
        visible: count > 0
    }
}
