import QtQuick 1.0
import "components"
import "scripts/widget.js" as Videos

Page {
    id: root

    property string videoFeed
    property bool loading: videoListModel.loading

    function setVideoFeed(feed) {
        videoFeed = feed;
        refresh();
    }

    function refresh() {
        videoListModel.clear();
        videoListModel.page = 0;
        videoListModel.totalResults = 0;
        videoListModel.error = false;
        Videos.getYouTubeVideos(videoFeed);
    }

    function up() {
        if (videoList.currentIndex > 2) {
            videoList.currentIndex = videoList.currentIndex - 3;
        }
        else {
            videoList.currentIndex = 0;
        }
    }

    function down() {
        if (videoList.currentIndex < videoListModel.count - 3) {
            videoList.currentIndex = videoList.currentIndex + 3;
        }
        else {
            videoList.currentIndex = videoListModel.count - 1;
        }
    }

    ListView {
        id: videoList

        anchors.fill: parent
        interactive: false
        highlightRangeMode: ListView.StrictlyEnforceRange
        cacheBuffer: 1000
        clip: true
        onCurrentIndexChanged: {
            if ((videoList.currentIndex > 0) && (videoList.count - videoList.currentIndex == 1)
                    && (videoListModel.count < videoListModel.totalResults)
                    && (!videoListModel.loading)) {
                Videos.getYouTubeVideos(videoFeed);
            }
        }

        footer: Item {
            id: footer

            width: videoList.width
            height: 83
            visible: videoListModel.loading
            opacity: footer.visible ? 1 : 0

            BusyDialog {
                anchors.centerIn: footer
                opacity: footer.opacity
            }
        }

        model: ListModel {
            id: videoListModel

            property bool loading : false
            property bool error: false
            property int totalResults
            property int page: 0
        }

        delegate: YTWidgetDelegate {
            id: delegate

            onClicked: Utils.displayVideo(playerUrl)
            onPlayClicked: playVideo(playerUrl, videoId, "youtube")
        }
    }

    Label {
        id: noResultsText

        anchors.centerIn: videoList
        font.pixelSize: _LARGE_FONT_SIZE
        font.bold: true
        color: "white"
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        text: qsTr("No videos found")
        visible: (!videoListModel.loading) && (videoListModel.count == 0)
    }
}
