import QtQuick 1.0
import "components"

Page {
    id: root

    title: qsTr("Settings") + " - " + qsTr("Media") + "/" + qsTr("Content")

    Flickable {
        id: flicker

        anchors { fill: parent; topMargin: titleArea.height }
        contentWidth: parent.width
        contentHeight: col1.height + 10
        flickableDirection: Flickable.VerticalFlick
        clip: true

        Column {
            id: col1

            anchors { top: parent.top; left: parent.left; right: parent.right }
            spacing: 20

            SelectionItem {
                title: qsTr("Media player")
                model: ListModel {
                    ListElement { name: QT_TR_NOOP("cuteTube Player"); value: "cutetubePlayer" }
                    ListElement { name: QT_TR_NOOP("Media Player"); value: "mediaplayer" }
                }
                onValueChosen: Settings.mediaPlayer = value

                Component.onCompleted: {
                    var mediaPlayers = Utils.getInstalledMediaPlayers();
                    for (var i = 0; i < mediaPlayers.length; i++) {
                        model.append(mediaPlayers[i]);
                    }
                    setInitialValue(Settings.mediaPlayer);
                }
            }

            SelectionItem {
                title: qsTr("YouTube widget feed")
                model: ListModel {
                    ListElement { name: QT_TR_NOOP("Most recent"); value: "_MOST_RECENT_FEED" }
                    ListElement { name: QT_TR_NOOP("My favourites"); value: "_FAVOURITES_FEED" }
                    ListElement { name: QT_TR_NOOP("My uploads"); value: "_UPLOADS_FEED" }
                    ListElement { name: QT_TR_NOOP("New subscription videos"); value: "_NEW_SUB_VIDEOS_FEED" }
                    ListElement { name: QT_TR_NOOP("Recommended videos"); value: "_RECOMMENDED_FEED" }
                    ListElement { name: QT_TR_NOOP("Search"); value: "youtubeSearch()" }
                    ListElement { name: QT_TR_NOOP("Watch later playlist"); value: "_WATCH_LATER_FEED" }
                }
                initialValue: Settings.youtubeWidgetFeed
                onValueChosen: Settings.youtubeWidgetFeed = value
            }

            SelectionItem {
                title: qsTr("Dailymotion widget feed")
                model: ListModel {
                    ListElement { name: QT_TR_NOOP("Most recent"); value: "_DM_MOST_RECENT_FEED" }
                    ListElement { name: QT_TR_NOOP("My favourites"); value: "_DM_FAVOURITES_FEED" }
                    ListElement { name: QT_TR_NOOP("My uploads"); value: "_DM_UPLOADS_FEED" }
                    ListElement { name: QT_TR_NOOP("New subscription videos"); value: "_DM_NEW_SUB_VIDEOS_FEED" }
                    ListElement { name: QT_TR_NOOP("Search"); value: "dailymotionSearch()" }
                }
                initialValue: Settings.dailymotionWidgetFeed
                onValueChosen: Settings.dailymotionWidgetFeed = value
            }

            Column {
                id: searchColumn

                x: 10
                width: parent.width - 20
                spacing: 20
                visible: (Settings.youtubeWidgetFeed == "youtubeSearch()") || (Settings.dailymotionWidgetFeed == "dailymotionSearch()")
                opacity: visible ? 1 : 0

                Behavior on opacity { NumberAnimation { duration: 200 } }

                Label {
                    font.bold: true
                    text: qsTr("Search query")
                    
                }

                TextField {
                    id: searchInput

                    width: parent.width
                    onTextChanged: Settings.searchQuery = text
                    Component.onCompleted: text = Settings.searchQuery
                }

                Label {
                    font.bold: true
                    
                    text: qsTr("Order by")
                }

                ButtonRow {
                    width: parent.width
                    buttons: [
                        TabButton {
                            text: qsTr("Date")
                            checked: Settings.searchOrder == "published"
                            onClicked: Settings.searchOrder = "published"
                        },

                        TabButton {
                            text: qsTr("Relevance")
                            checked: Settings.searchOrder == "relevance"
                            onClicked: Settings.searchOrder = "relevance"
                        },

                        TabButton {
                            text: qsTr("Views")
                            checked: Settings.searchOrder == "viewCount"
                            onClicked: Settings.searchOrder = "viewCount"
                        },

                        TabButton {
                            text: qsTr("Rating")
                            checked: Settings.searchOrder == "rating"
                            onClicked: Settings.searchOrder = "rating"
                        }
                    ]
                }

                Label {
                    font.bold: true
                    
                    text: qsTr("Duration")
                }

                ButtonRow {
                    width: parent.width
                    buttons: [
                        TabButton {
                            text: qsTr("Any")
                            checked: Settings.durationFilter == "all"
                            onClicked: Settings.durationFilter = "all"
                        },

                        TabButton {
                            text: "< 4"
                            checked: Settings.durationFilter == "short"
                            onClicked: Settings.durationFilter = "short"
                        },

                        TabButton {
                            text: "<= 20"
                            checked: Settings.durationFilter == "medium"
                            onClicked: Settings.durationFilter = "medium"
                        },

                        TabButton {
                            text: "> 20"
                            checked: Settings.durationFilter == "long"
                            onClicked: Settings.durationFilter = "long"
                        }
                    ]
                }
            }
        }
    }
}
