import QtQuick 1.0
import "components"

QueryDialog {
    id: root

    property string videoId

    signal metadataUpdated(variant metadata)

    function getVideoMetadata(id) {
        var request = new XMLHttpRequest();
        request.onreadystatechange = function() {
            if (request.readyState == XMLHttpRequest.DONE) {
                try {
                    var res = eval("(" + request.responseText + ")");
                    videoId = res.id;
                    titleInput.text = res.title;
                    descriptionInput.text = res.description;
                    categorySelector.setInitialValue(res.channel);
                    tagsInput.text = res.tags.toString();
                    privateCheckbox.checked = res.private;
                    busyDialog.visible = false;
                }
                catch(err) {
                    busyDialog.visible = false;
                    messages.displayMessage(qsTr("Cannot retrieve video details"));
                    console.log("Cannot retrieve video");
                }
            }
        }
        request.open("GET", "https://api.dailymotion.com/video/" + id + "?fields=id,title,description,tags,channel,private");
        request.setRequestHeader("Authorization", "OAuth " + Dailymotion.accessToken);
        request.send();
    }

    function updateMetadata() {
        toggleBusy(true);
        var metadata = {};
        metadata["title"] = titleInput.text;
        metadata["description"] = descriptionInput.text;
        metadata["tags"] = "[" + tagsInput.text + "]";
        metadata["channel"] = categorySelector.currentValue;
        metadata["private"] = privateCheckbox.checked.toString();
        Dailymotion.updateVideoMetadata(videoId, metadata);
        metadataUpdated(metadata);
    }

    titleText: qsTr("Edit metadata")
    acceptButtonText: qsTr("Update")
    rejectButtonText: qsTr("Cancel")
    onAccepted: updateMetadata()
    content: Item {
        anchors.fill: parent

        Flickable {
            id: flicker

            anchors.fill: parent
            contentWidth: width
            contentHeight: col1.height + 20
            flickableDirection: Flickable.VerticalFlick
            clip: true

            Column {
                id: col1

                z: 101
                anchors { top: parent.top; left: parent.left; right: parent.right }
                spacing: 20
                visible: !busyDialog.visible

                Label {
                    font.bold: true
                    
                    text: qsTr("Title")
                }

                TextField {
                    id: titleInput

                    width: parent.width
                }

                Label {
                    font.bold: true
                    
                    text: qsTr("Description")
                }

                TextArea {
                    id: descriptionInput

                    width: parent.width
                }

                Label {
                    font.bold: true
                    
                    text: qsTr("Tags (separated by commas)")
                }

                TextField {
                    id: tagsInput

                    width: parent.width
                }

                SelectionItem {
                    id: categorySelector

                    width: parent.width
                    title: qsTr("Channel")
                    model: ListModel {
                        ListElement { name: QT_TR_NOOP("Animals"); value: "animals" }
                        ListElement { name: QT_TR_NOOP("Arts"); value: "arts" }
                        ListElement { name: QT_TR_NOOP("Auto-Moto"); value: "auto" }
                        ListElement { name: QT_TR_NOOP("College"); value: "schools" }
                        ListElement { name: QT_TR_NOOP("Film & TV"); value: "shortfilms" }
                        ListElement { name: QT_TR_NOOP("Funny"); value: "fun" }
                        ListElement { name: QT_TR_NOOP("Gaming"); value: "videogames" }
                        ListElement { name: QT_TR_NOOP("Gay & Lesbian"); value: "gaylesbian" }
                        ListElement { name: QT_TR_NOOP("Kids"); value: "kids" }
                        ListElement { name: QT_TR_NOOP("Life & Style"); value: "lifestyle" }
                        ListElement { name: QT_TR_NOOP("Most Recent"); value: "MostRecent" }
                        ListElement { name: QT_TR_NOOP("Most Viewed"); value: "MostViewed" }
                        ListElement { name: QT_TR_NOOP("Music"); value: "music" }
                        ListElement { name: QT_TR_NOOP("News & Politics"); value: "news" }
                        ListElement { name: QT_TR_NOOP("People & Family"); value: "people" }
                        ListElement { name: QT_TR_NOOP("Sexy"); value: "sexy" }
                        ListElement { name: QT_TR_NOOP("Sports & Extreme"); value: "sport" }
                        ListElement { name: QT_TR_NOOP("Tech & Science"); value: "tech" }
                        ListElement { name: QT_TR_NOOP("Travel"); value: "travel" }
                        ListElement { name: QT_TR_NOOP("Webcam & Vlogs"); value: "webcam" }
                    }
                    isChild: true
                    onOpened: lowerOpacity()
                    onAccepted: raiseOpacity()
                    onClosed: root.close()
                }

                CheckBox {
                    id: privateCheckbox

                    text: qsTr("Private?")
                }
            }
        }

        BusyDialog {
            id: busyDialog

            anchors.centerIn: parent
        }
    }
}
