import QtQuick 1.0
import QtMobility.gallery 1.1
import "components"

Page {
    id: root

    function up() {
        if (videoList.currentIndex > 2) {
            videoList.currentIndex = videoList.currentIndex - 3;
        }
        else {
            videoList.currentIndex = 0;
        }
    }

    function down() {
        if (videoList.currentIndex < archiveModel.count - 3) {
            videoList.currentIndex = videoList.currentIndex + 3;
        }
        else {
            videoList.currentIndex = archiveModel.count - 1;
        }
    }

    function refresh() {
        archiveModel.reload();
    }

    Timer {
        id: reloadTimer

        interval: 3000
        onTriggered: refresh()
    }

    Connections {
        target: Settings
        onArchiveUpdated: reloadTimer.restart()
        onDownloadPathChanged: reloadTimer.restart()
    }

    ListView {
        id: videoList

        anchors.fill: parent
        highlightRangeMode: ListView.StrictlyEnforceRange
        cacheBuffer: 1000
        clip: true
        model: DocumentGalleryModel {
            id: archiveModel

            rootItem: "folder::" + Settings.downloadPath.slice(0, -1)
            rootType: DocumentGallery.File
            scope: DocumentGalleryModel.DirectDescendants
            properties: ["filePath", "fileName"]
            sortProperties: ["-lastModified"]
            filter: GalleryFilterUnion {
                filters: [
                    GalleryWildcardFilter {
                        property: "fileName"
                        value: "*.mp4"
                    },
                    GalleryWildcardFilter {
                        property: "fileName"
                        value: "*.m4a"
                    }
                ]
            }
        }
        delegate: ArchiveWidgetDelegate {
            id: delegate

            onClicked: playVideo(filePath, "", "archive")
        }

        footer: Item {
            id: footer

            width: videoList.width
            height: 83
            visible: archiveModel.status == DocumentGalleryModel.Active
            opacity: footer.visible ? 1 : 0

            BusyDialog {
                anchors.centerIn: footer
                opacity: footer.opacity
            }
        }
    }

    Label {
        id: noResultsText

        anchors.centerIn: videoList
        font.pixelSize: _LARGE_FONT_SIZE
        font.bold: true
        color: "#4d4d4d"
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        text: qsTr("Archive empty")
        visible: (archiveModel.status != DocumentGalleryModel.Active) && (archiveModel.count === 0)
    }
}
