import QtQuick 1.0
import "components"
import "scripts/dateandtime.js" as DT

Item {
    id: delegate

    property bool checked

    signal clicked
    signal pressAndHold

    width: parent.width
    height: 150
    smooth: true

    ListHighlight {
        visible: (mouseArea.pressed) || (delegate.checked)
    }

    Label {
        id: titleText

        height: 140
        anchors { left: frame.right; leftMargin: 5; right: delegate.right; rightMargin: 5; top: frame.top }
        text: fileName.slice(0, fileName.lastIndexOf("."))
        color: _TEXT_COLOR
        font.pixelSize: _STANDARD_FONT_SIZE
        font.bold: true
        verticalAlignment: Text.AlignTop
        wrapMode: Text.WordWrap
        clip: true
    }

    Image {
        id: frame

        z: 1
        width: 162
        height: 122
        anchors { left: delegate.left; top: delegate.top; margins: 5 }
        source: "images/frame.png"
        sourceSize.width: width
        sourceSize.height: height
        smooth: true

        Image {
            id: thumb

            z: -1
            anchors.fill: frame
            source: Settings.downloadPath + ".thumbnails/" + fileName.slice(0, fileName.lastIndexOf(".")) + ".jpg"
            smooth: true
            onStatusChanged: if (thumb.status == Image.Error) thumb.source = !theme.inverted ? "images/video.png" : "images/video-white.png";
        }
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        onClicked: parent.clicked()
        onPressAndHold: parent.pressAndHold()
    }
}

