#ifndef SETTINGS_H
#define SETTINGS_H

#include "qmlapplicationviewer.h"
#include <QSettings>

class Settings : public QSettings
{
    Q_OBJECT

    Q_PROPERTY(QString youtubeWidgetFeed
               READ getYouTubeWidgetFeed
               WRITE setYouTubeWidgetFeed
               NOTIFY youtubeWidgetFeedChanged)
    Q_PROPERTY(QString dailymotionWidgetFeed
               READ getDailymotionWidgetFeed
               WRITE setDailymotionWidgetFeed
               NOTIFY dailymotionWidgetFeedChanged)
    Q_PROPERTY(QString searchQuery
               READ getSearchQuery
               WRITE setSearchQuery
               NOTIFY searchQueryChanged)
    Q_PROPERTY(QString searchOrder
               READ getSearchOrder
               WRITE setSearchOrder
               NOTIFY searchOrderChanged)
    Q_PROPERTY(QString durationFilter
               READ getDurationFilter
               WRITE setDurationFilter
               NOTIFY durationFilterChanged)
    Q_PROPERTY(QString appTheme
               READ getTheme
               WRITE setTheme
               NOTIFY themeChanged)
    Q_PROPERTY(QString activeColor
               READ getActiveColor
               WRITE setActiveColor
               NOTIFY activeColorChanged)
    Q_PROPERTY(QString activeColorString
               READ getActiveColorString
               WRITE setActiveColorString
               NOTIFY activeColorStringChanged)
    Q_PROPERTY(QString gradientColor
               READ getGradientColor
               NOTIFY gradientColorChanged)
    Q_PROPERTY(QString gradientColorHigh
               READ getGradientColorHigh
               NOTIFY gradientColorHighChanged)
    Q_PROPERTY(QString mediaPlayer
               READ getMediaPlayer
               WRITE setMediaPlayer
               NOTIFY mediaPlayerChanged)

public:
    explicit Settings(QSettings *parent = 0);
    virtual ~Settings();
    QString getYouTubeWidgetFeed() const { return youtubeWidgetFeed; }
    QString getDailymotionWidgetFeed() const { return dailymotionWidgetFeed; }
    QString getSearchQuery() const { return searchQuery; }
    QString getSearchOrder() const { return searchOrder; }
    QString getDurationFilter() const { return durationFilter; }
    QString getTheme() const { return theme; }
    QString getActiveColor() const { return activeColor; }
    QString getActiveColorString() const { return activeColorString; }
    QString getGradientColor() const { return gradientColor; }
    QString getGradientColorHigh() const { return gradientColorHigh; }
    QString getMediaPlayer() const { return mediaPlayer; }
    QString getLanguage() const { return language; }
    void restoreSettings();

signals:
    void youtubeWidgetFeedChanged();
    void dailymotionWidgetFeedChanged();
    void searchQueryChanged();
    void searchOrderChanged();
    void durationFilterChanged();
    void themeChanged();
    void activeColorChanged();
    void activeColorStringChanged();
    void gradientColorChanged();
    void gradientColorHighChanged();
    void alert(const QString &message);
    void mediaPlayerChanged();
    void orientationChanged(const QString &orientation);

public slots:
    void saveSettings();
    void setYouTubeWidgetFeed(const QString &feed, bool update = true);
    void setDailymotionWidgetFeed(const QString &feed, bool update = true);
    void setSearchQuery(const QString &query, bool update = true);
    void setSearchOrder(const QString &order, bool update = true);
    void setDurationFilter(const QString &filter, bool update = true);
    void setTheme(const QString &aTheme);
    void setActiveColor(const QString &color, bool update = true);
    void setActiveColorString(const QString &colorString, bool update = true);
    void setMediaPlayer(const QString &player, bool update = true);

private:
    void setGradientColor(const QString &color);
    void setGradientColorHigh(const QString &color);
    void setLanguage(const QString &lang);
    void setOrientation(const QString &orientation);
    void updateWidgetSetting(const QString &method, const QString &arg);

private:
    QString youtubeWidgetFeed;
    QString dailymotionWidgetFeed;
    QString searchQuery;
    QString searchOrder;
    QString durationFilter;
    QString theme;
    QString activeColor;
    QString activeColorString;
    QString gradientColor;
    QString gradientColorHigh;
    QString mediaPlayer;
    QString language;
    QString screenOrientation;
};

#endif // SETTINGS_H
