import Qt 4.7

Item {

    property string playlistId
    property string title

    signal playClicked(string playlistId)
    signal downloadClicked(string playlistId)
    signal infoClicked(string playlistId, string title)

    function setPlaylist(playlist) {
        playlistId = playlist.playlistId;
        title = playlist.title;
    }

    id: dialog
    width: 400
    height: 200

    Rectangle {
        id: background
        color: backgroundColor
        radius: 10
        opacity: 0.7
        width: parent.width; height: parent.height
        border.width: 2
        border.color: activeColorHigh
    }
    PushButton {
        id: playButton

        width: 100
        height: 100
        icon: "ui-images/playicon.png"
        anchors { verticalCenter: dialog.verticalCenter; left: dialog.left; margins: 25 }

        Connections {
            onButtonClicked: playClicked(playlistId)
        }
    }
    PushButton {
        id: downloadButton

        width: 100
        height: 100
        icon: "ui-images/downloadicon.png"
        iconWidth: 60
        iconHeight: 60
        anchors { horizontalCenter: dialog.horizontalCenter; verticalCenter: dialog.verticalCenter }

        Connections {
            onButtonClicked: downloadClicked(playlistId)
        }
    }
    PushButton {
        id: infoButton

        width: 100
        height: 100
        icon: "ui-images/videosicon.png"
        anchors { verticalCenter: dialog.verticalCenter; right: dialog.right; margins: 25 }

        Connections {
            onButtonClicked: infoClicked(playlistId, title)
        }
    }
    Text {
        id: titleText

        width: dialog.width
        anchors { top: dialog.top; left: dialog.left; right: dialog.right; margins: 10 }
        elide: Text.ElideRight
        horizontalAlignment: Text.AlignHCenter
        font.pixelSize: smallFontSize
        color: textColor
        text: title
    }

    MouseArea {
        z: -1
        anchors.fill: dialog
    }
}
