#include "qmlapplicationviewer.h"
#include "controller.h"
#include "youtube.h"
#include "sharing.h"
#include "downloadmanager.h"
#include "folderlistmodel.h"
#include <QtGui/QApplication>
#include <QDeclarativeContext>
#include <QtDeclarative>

//#ifdef Q_WS_MAEMO_5
//#include <QtOpenGL/QGLWidget>
//#endif

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);
    app.setApplicationName("FMRadio");

    QmlApplicationViewer viewer;

    QDeclarativeContext *context = viewer.rootContext();
    Controller ct;
    ct.setView(&viewer);
    YouTube yt;
    Sharing sh;
    DownloadManager dm;
    QNetworkAccessManager *manager = new QNetworkAccessManager();
    yt.setNetworkAccessManager(manager);
    dm.setNetworkAccessManager(manager);
    sh.setNetworkAccessManager(manager);
    context->setContextProperty("Controller", &ct);
    context->setContextProperty("DownloadManager", &dm);
    context->setContextProperty("YouTube", &yt);
    context->setContextProperty("Sharing", &sh);

    qmlRegisterType<QDeclarativeFolderListModel>("Models",1,0,"FolderListModel");

#ifdef Q_WS_MAEMO_5
    viewer.engine()->addImportPath(QString("/opt/qtm12/imports"));
    //    viewer.engine()->addPluginPath(QString("/opt/qtm12/plugins"));
    viewer.engine()->setOfflineStoragePath("/home/user/.config/cutetube");
    QDir path;
    path.setPath("/home/user/.config/cutetube");
    if (!path.exists()) {
        path.mkpath("/home/user/.config/cutetube");
    }
    path.setPath("/home/user/MyDocs/.cutetube");
    if (!path.exists()) {
        path.mkpath("/home/user/MyDocs/.cutetube");
    }
    //    viewer.setViewport(new QGLWidget());

    QString locale = ct.getLanguage();

    QTranslator translator;

    if (translator.load("/opt/usr/share/qmltube/qml/qmltube/i18n/qml_" + locale)) {
        app.installTranslator(&translator);
    }
#endif

    viewer.setMainQmlFile(QLatin1String("qml/qmltube/main.qml"));
    viewer.showFullScreen();

    return app.exec();
}
