import QtQuick 1.0
import Models 1.0

Item {
    id: dialog

    property alias title : title.text
    property alias showFiles : folderModel.showFiles
    property alias folder : folderModel.folder
    property alias showButton : saveButton.visible

    signal fileChosen(string filepath)
    signal settingChosen(string setting)
    signal close

    width: 600
    height: 300
    opacity: 0

    Behavior on opacity { PropertyAnimation { properties: "opacity"; duration: 500 } }

    Rectangle {
        id: background

        anchors.fill: dialog
        color: "black"
        opacity: 0.5
        radius: 10
        border.width: 2
        border.color: activeColor
    }

    Text {
        id: title

        anchors { horizontalCenter: dialog.horizontalCenter; top: dialog.top; topMargin: 10 }
        text: "Choose video file"
        font.pixelSize: smallFontSize
        color: "white"
    }

    CloseButton {
        id: closeButton

        onButtonClicked: {
            dialog.opacity = 0;
            close();
        }
    }

    Text {
        id: folderText

        property string folderName : folderModel.folder

        anchors { left: dialog.left; leftMargin: 10; right: dialog.right; rightMargin: 10; top: dialog.top; topMargin: 50 }
        elide: Text.ElideRight
        text: folderName.substr(7)
        font.pixelSize: smallFontSize
        color: activeColorLow
    }

    ListView {
        id: fileList

        property alias fmodel : folderModel

        anchors { fill: dialog; leftMargin: 10; rightMargin: (saveButton.visible && dialog.state == "") ? 170 : 10; topMargin: 80; bottomMargin: 10 }
        clip: true
        interactive: visibleArea.heightRatio < 1

        model: FolderListModel {
            id: folderModel

            nameFilters: [ "*.avi", "*.divx", "*.flv", "*.mp4", "*.mkv", "*.mpg", "*.wmv" ]
            showDotAndDotDot: true
            showFiles: true
            folder: "/home/user/MyDocs"
        }

        delegate: FileChooserDelegate {
            id: delegate

            Connections {
                onDelegateClicked: {
                    fileList.currentIndex = index;
                    if (!folderModel.isFolder(index)) {
                        fileChosen(filepath);
                        dialog.opacity = 0;
                        close();
                    }
                    else {
                        folderModel.folder = filepath;
                    }
                }
            }
        }

        ScrollBar {}        
    }

    PushButton {
        id: saveButton

        anchors { right: dialog.right; bottom: dialog.bottom; margins: 10 }
        icon: "ui-images/tick.png"
        visible: false

        Connections {
            onButtonClicked: {
                settingChosen(folderText.folderName.substr(7) + "/");
                dialog.opacity = 0;
                close();
            }
        }
    }

    MouseArea {
        z: -1
        anchors.fill: dialog
    }

    states: State {
        name: "portrait"
        PropertyChanges { target: dialog; width: 460; height: 550 }
        PropertyChanges { target: saveButton; buttonWidth: 440 }
        PropertyChanges { target: fileList; anchors.bottomMargin: 90 }
    }
}
