#include <QDebug>
#include <QtGui/QApplication>
#include <QTextCodec>

#include "mainwindow.h"

//#include <QTime>
//#include <QDebug>
//QTime tTimer;

#ifdef Q_OS_WINCE
int WinMain(int argc, char *argv[])
#else
int main(int argc, char *argv[])
#endif
{

#if defined(Q_OS_WINCE) // mutex - single app
 wchar_t uniqueAppID[MAX_PATH];
 GetModuleFileName(0, uniqueAppID, MAX_PATH);
 QString uid = QString::fromWCharArray(uniqueAppID).toLower().replace(QLatin1String("\\"), QLatin1String("_"));

 HANDLE mutex = CreateMutex(NULL, TRUE, (LPCWSTR)uid.utf16());
 if (mutex && ERROR_ALREADY_EXISTS == GetLastError()) {
  CloseHandle(mutex);

  UINT msgNo = RegisterWindowMessage((LPCWSTR)uid.utf16());
  HWND aHwnd = FindWindow((LPCWSTR)QString::number(msgNo).utf16(), 0);
  if (aHwnd)
   SetForegroundWindow((HWND)(((ULONG)aHwnd) | 0x01));
  return 0;
 }
#endif // Q_OS_WINCE

 QApplication a(argc, argv);
//#ifdef Q_OS_WIN32
// a.setStyle("cleanlooks");
//#endif
 QTextCodec *codec = QTextCodec::codecForName("cp1251");
 QTextCodec::setCodecForTr(codec);

 //tTimer.start();
 MainWindow w;
 //qDebug() << tTimer.elapsed(); return 0;

 int result = a.exec();

#if defined(Q_OS_WINCE)
 CloseHandle(mutex);
#endif
 return result;
}
