#ifndef SETTINGS_H
#define SETTINGS_H

#include <QDialog>
#include "mainwindow.h"

namespace Ui {
    class Settings;
}

class Settings : public QDialog
{
    Q_OBJECT

public:
    explicit Settings(QWidget *parent = 0);
    ~Settings();
    void loadSettingsToUi(const IniSettingMap &set);

    Ui::Settings *ui;
    IniSettingMap DefaultConfig;

private:
    void closeEvent(QCloseEvent * e);
    void updateLabelCacheSize();

    QColor SBackColor,SShadowColor,MBackColor;

protected:
    void keyPressEvent(QKeyEvent *e);
    void showEvent(QShowEvent *e);

signals:
    void closed();
    void showed();

private slots:

    void on_bMEmptyExit_clicked();
    void on_buttonBox_accepted();
    void on_buttonBox_rejected();
    void on_bSFont_clicked();
    void on_bSBackColor_clicked();
    void on_bSShadowColor_clicked();
    void on_bMBackColor_clicked();

    IniSettingMap changeSettings();


    void on_bDefaultConfig_clicked();
};

#endif // SETTINGS_H
