#ifndef ABOUT_H
#define ABOUT_H

#include <QtGui>
#include <QDialog>

#include "mainwindow.h"
#include "flickcharm.h"

#ifdef Q_OS_SYMBIAN
extern QString VERSION;
#endif
extern MainWindow *mainWnd;
extern QString URL_MAPS;

class About : public QDialog
{
    Q_OBJECT

public:
    explicit About(QWidget *parent): QDialog(parent)
    {
     //Logo= new QLabel();
     OK=NULL;
     Info= new QTextBrowser();
     //Info->setStyleSheet("border:1px solid grey;");
     setWindowTitle(tr("About")+" qMetro");
#ifdef Q_WS_MAEMO_5
     setAttribute(Qt::WA_Maemo5StackedWindow);
     setWindowFlags(Qt::Window);
     setAttribute(Qt::WA_Maemo5AutoOrientation);
#else
     FlickCharm *fcharm=new FlickCharm(Info);
     fcharm->activateOn(Info);
#endif

     setWindowFlags(windowFlags() & (~Qt::WindowContextHelpButtonHint));
     setAttribute(Qt::WA_DeleteOnClose);
     setMinimumWidth(260);
     setMinimumHeight(220);
     resize(500,400);

     //Logo->setFixedWidth(64);
     //Logo->setContentsMargins(0,5,0,0);
     //Logo->setPixmap(QPixmap(":/qmetro.png"));

     QString hr=QString("<p><table height=\"2\" width=\"100%\" bgcolor=\"%1\"><tr><td></table></p>")
                .arg(palette().color(QPalette::Mid).name());
     QString text=
     QString("<table><tr><td align=\"center\" style=\"padding-right:6px;\">"
             "<img "+(0 ? QString("width=\"%1\" height=\"%1\"").arg(mainWnd->Config.appIconSize):"")+" align=\"left\" src=\":/qmetro.png\">"
             "<a href=\"https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=9EZQ47YPVAF36\">"
             "<img "+(0 ? QString("width=\"%1\" height=\"%2\"").arg(mainWnd->Config.appIconSize).arg(mainWnd->Config.appIconSize/1.6):"")+" src=\":/img/donate.png\"></a>"
             "<td><p><font size=6><b>qMetro</b></font><br>"
             "%4<br><br>"
             "%5 %1<br>"
             "&copy; 2011-2012<br><a href=\"mailto:guuleon@gmail.com\">Gusak Leonid</a><br>"
             "<a href=\"http://qmetro.sf.net\">qmetro.sf.net</a></table></p>"
             "<hr><br>%6:<br><a href=\"mailto:Boris@pMetro.su\">Muradov Boris</a>"
             " (<a href=\"%10\">pMetro</a>)"
             "<br><br>%11"
             "<hr><b>%7:</b>"
             "<p>%3</p>"
             "<hr><b>%8:</b><ul type=\"circle\"><li>&nbsp;Qt %2<li>&nbsp;zlib + OSDaB</ul>"
             "<hr>%9")
     .arg(VERSION).arg(QT_VERSION_STR).arg((mainWnd->map->params.mapAuthors.isEmpty() ? tr("Unknown author"):mainWnd->map->params.mapAuthors)) // 1
     .arg(tr("transit system map")).arg(tr("Version")).arg(tr("Author of map file format")) // 3
     .arg(tr("About current map file")).arg(tr("This program uses")) // 6
     .arg(tr("This program is distributed in the hope that it will be useful, "
             "but WITHOUT ANY WARRANTY; without even the implied warranty of "
             "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the "
             "GNU General Public License for more details.")).arg(URL_MAPS).arg(tr("Author of translation: Gusak Leonid").replace(": ",":<br>"));

     text.replace("<hr>",hr);

//     Info->setAttribute(Qt::WA_NoSystemBackground);
     QPalette pal = Info->palette();
     pal.setBrush(QPalette::Base, palette().color(QPalette::Window));
     pal.setColor(QPalette::Text,palette().color(QPalette::Text));
     Info->setPalette(pal);

     Info->setTextInteractionFlags(Qt::LinksAccessibleByMouse | Qt::TextSelectableByMouse);
     Info->setOpenExternalLinks(1);
     Info->setReadOnly(1);
     Info->setFrameShape(QFrame::NoFrame);
     Info->setText(text);

     //HLayout= new QHBoxLayout;
     VLayout= new QVBoxLayout;
     VLayout->setMargin(2);
     //HLayout->addWidget(Logo);
     //HLayout->setAlignment(Logo,Qt::AlignTop);
     VLayout->addWidget(Info);
//#ifndef Q_WS_MAEMO_5
     if(mainWnd->MobileVersion)
     {
      //OK= new QDialogButtonBox(QDialogButtonBox::Ok);
      OK = new QPushButton(tr("OK"));
      //connect(OK,SIGNAL(clicked()),mainWnd,SLOT(toFullScreen()));
      connect(OK,SIGNAL(clicked()),this,SLOT(close()));
      connect(OK,SIGNAL(clicked()),mainWnd,SLOT(showPageMap()));
      VLayout->addWidget(OK);
     }
//#endif
     setLayout(VLayout);
     //connect(this,SIGNAL())
     if(OK) OK->setFocus();
    }
    ~About()
    {
     if(OK) delete OK;
     delete Info;
    }

private:
//    void closeEvent(QCloseEvent *e)
//    {Q_UNUSED(e);
//     deleteLater();
//    }

    QHBoxLayout *HLayout;
    QVBoxLayout *VLayout;
    //QDialogButtonBox *OK;
    QPushButton *OK;
    //QLabel *Logo;
    QTextBrowser *Info;

protected:
    void keyPressEvent(QKeyEvent *e)
    {
     if(e->key()==Qt::Key_Escape) close();
    }

//    bool event(QEvent *e)
//    {
//     if(e->type()==QEvent::WindowDeactivate)
//     {
//      close();
//      return true;
//     }
//     return QWidget::event(e);
//    }
};

#endif // ABOUT_H
