#include <QDebug>
#include <QFile>
#include <QKeyEvent>
#include <QColorDialog>
#include <QFontDialog>
#include <QSettings>


#include "settings.h"
#include "mainwindow.h"
#include "ui_settings.h"
#include "flickcharm.h"

extern MainWindow *mainWnd;
extern IniSettingMap AppConfig;
extern QString appPath,appConfigFile,cachePath;

Settings::Settings(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Settings),SBackColor(Qt::white),SShadowColor(Qt::white),MBackColor(Qt::white)
{
 bool MobileVersion=mainWnd->MobileVersion;
 setWindowFlags(windowFlags() & (~Qt::WindowContextHelpButtonHint));

 ui->setupUi(this);
 QFontMetrics fmWidth(font());
 int WindowWidth=fmWidth.width(ui->checkMFastScrolling->text())+50;
 setMinimumWidth(WindowWidth);
 setMaximumWidth(WindowWidth+50);
 resize(WindowWidth,WindowWidth*1.4);
#ifndef Q_WS_MAEMO_5
 QObjectList l = ui->toolBox->children();
 for (QObjectList::iterator it = l.begin(); it < l.end(); it++)
  if (QScrollArea *scroll = dynamic_cast<QScrollArea *>(*it))
  {
   FlickCharm *fcharm = new FlickCharm(scroll);
   fcharm->activateOn(scroll);
   if(!MobileVersion) scroll->setVerticalScrollBarPolicy(Qt::ScrollBarAsNeeded);
  }
#endif

 QFontMetrics fm(ui->toolBox->font());
 QString ToolStyle="QToolBox{icon-size:%1px;}"+ui->toolBox->styleSheet();
 ui->toolBox->setStyleSheet(ToolStyle.arg(fm.height()+1));
 ui->toolBox->setCurrentIndex(0);
 ui->gbFontStation->setVisible(0);
 ui->gbFontStation->setAttribute(Qt::WA_NoSystemBackground);;
 updateLabelCacheSize();
 QString TextColor=tr("Color...");
 ui->bSBackColor->setText(TextColor);
 ui->bSShadowColor->setText(TextColor);
 ui->bMBackColor->setText(TextColor);

 //if(!QFile::exists(appConfigFile)) saveSettings(changeSettings());

 if(!MobileVersion)
 {
  connect(ui->bSFont,SIGNAL(clicked()),this,SLOT(changeSettings()));
  connect(ui->checkSCustomFont,SIGNAL(clicked()),this,SLOT(changeSettings()));
  connect(ui->checkSBackColor,SIGNAL(clicked()),this,SLOT(changeSettings()));
  connect(ui->checkSShadow,SIGNAL(clicked()),this,SLOT(changeSettings()));
  connect(ui->bSBackColor,SIGNAL(clicked()),this,SLOT(changeSettings()));
  connect(ui->bSShadowColor,SIGNAL(clicked()),this,SLOT(changeSettings()));
  connect(ui->spinSTransparency,SIGNAL(valueChanged(int)),this,SLOT(changeSettings()));
  connect(ui->checkSUpperCase,SIGNAL(clicked()),this,SLOT(changeSettings()));
  //connect(ui->checkSWordWrap,SIGNAL(clicked()),this,SLOT(changeSettings()));
  connect(ui->checkMShowScrollbar,SIGNAL(clicked()),this,SLOT(changeSettings()));
  connect(ui->checkMShowTime,SIGNAL(clicked()),this,SLOT(changeSettings()));
  connect(ui->checkMShowBackground,SIGNAL(clicked()),this,SLOT(changeSettings()));
  connect(ui->checkMAntialiasing,SIGNAL(clicked()),this,SLOT(changeSettings()));
  connect(ui->checkMFastScrolling,SIGNAL(clicked()),this,SLOT(changeSettings()));
  connect(ui->bMBackColor,SIGNAL(clicked()),this,SLOT(changeSettings()));
  connect(ui->checkMCaching,SIGNAL(clicked()),this,SLOT(changeSettings()));

  //connect(ui->checkMSimpleTransfers,SIGNAL(clicked()),this,SLOT(changeSettings()));

  connect(ui->checkWFullScreen,SIGNAL(clicked()),this,SLOT(changeSettings()));

  //connect(ui->checkMCleanCache,SIGNAL(clicked()),this,SLOT(changeSettings()));
 }

 connect(ui->spinUiScale,SIGNAL(valueChanged(int)),mainWnd,SLOT(setScaleForUi(int)));
}

void Settings::closeEvent(QCloseEvent * e)
{Q_UNUSED(e);
 applySettings(AppConfig);
 ((MainWindow*)parent())->SettingWindow=NULL;
 delete this;
}

Settings::~Settings()
{
    delete ui;
}

void Settings::keyPressEvent(QKeyEvent *e)
{
 if(e->key()==Qt::Key_Escape) close();
}

void getColorFromDialog(QPushButton *button,QColor &color)
{
 QColorDialog Dialog;
 Dialog.setCurrentColor(color);
 Dialog.exec();
 if(Dialog.result()==1)
 {
  color=Dialog.selectedColor();
  button->setStyleSheet(QString("background: %1").arg(color.name()));
 }
}

void Settings::on_bSBackColor_clicked()
{ getColorFromDialog(ui->bSBackColor,SBackColor); }

void Settings::on_bSShadowColor_clicked()
{ getColorFromDialog(ui->bSShadowColor,SShadowColor); }

void Settings::on_bMBackColor_clicked()
{ getColorFromDialog(ui->bMBackColor,MBackColor); }

QFont getFontFromLabel(QLabel *Label)
{
 QFont Font;
 Font=Label->font();
 Font.setPointSizeF(Label->text().section(",",-1).toFloat());
 return Font;
}

void setFontToLabel(QLabel *Label,QFont &Font)
{
 qreal Size=Font.pointSizeF();
 Font.setPointSizeF(Label->font().pointSizeF());
 Label->setFont(Font);
 Label->setText(QString("%1, %2").arg(Font.family()).arg(Size));
}

void Settings::on_bSFont_clicked()
{
 bool ok;
 QFont NewFont;
 NewFont=QFontDialog::getFont(&ok,getFontFromLabel(ui->labelSFont),this);
 if(ok)
  setFontToLabel(ui->labelSFont,NewFont);
}

void Settings::on_buttonBox_accepted()
{
  saveSettings(changeSettings());
}

void Settings::on_buttonBox_rejected()
{
 applySettings(AppConfig);
 ((MainWindow*)parent())->SettingWindow=NULL;
 delete this;
}

IniSettingMap Settings::changeSettings()
{
 IniSettingMap Setting;
 //if(!isVisible()) return Setting;

 // [MapView]
 IniKeyMap MapKeys;
 MapKeys.insert(ikStationCustomFont,QString::number(ui->checkSCustomFont->isChecked()));
 MapKeys.insert(ikStationFont,getFontFromLabel(ui->labelSFont).toString());
 MapKeys.insert(ikStationBack,QString::number(ui->checkSBackColor->isChecked()));
 MapKeys.insert(ikStationShadow,QString::number(ui->checkSShadow->isChecked()));
 MapKeys.insert(ikSBackColor,SBackColor.name());
 MapKeys.insert(ikSShadowColor,SShadowColor.name());
 MapKeys.insert(ikSUpperCase,QString::number(ui->checkSUpperCase->isChecked()));
 MapKeys.insert(ikSWordWrap,QString::number(ui->checkSWordWrap->isChecked()));

 MapKeys.insert(ikSTransparency,QString::number(ui->spinSTransparency->value()));
 MapKeys.insert(ikMShowScrollbar,QString::number(ui->checkMShowScrollbar->isChecked()));
 MapKeys.insert(ikMShowTime,QString::number(ui->checkMShowTime->isChecked()));
 MapKeys.insert(ikMShowBackground,QString::number(ui->checkMShowBackground->isChecked()));
 MapKeys.insert(ikMAntialiasing,QString::number(ui->checkMAntialiasing->isChecked()));
 MapKeys.insert(ikMFastScrolling,QString::number(ui->checkMFastScrolling->isChecked()));
 MapKeys.insert(ikMSimpleTransfers,QString::number(ui->checkMSimpleTransfers->isChecked()));
 MapKeys.insert(ikMBackColor,MBackColor.name());
 MapKeys.insert(ikMCaching,QString::number(ui->checkMCaching->isChecked()));
 Setting.insert(igMapView,MapKeys);

 // [Main]
 IniKeyMap MainKeys;
 MainKeys.insert(ikWFullScreen,QString::number(ui->checkWFullScreen->isChecked()));
 MainKeys.insert(ikWUiScale,QString::number(ui->spinUiScale->value()/100.0));
 Setting.insert(igMain,MainKeys);

 // [Other]
 IniKeyMap OtherKeys;
 OtherKeys.insert(ikMCleanCache,QString::number(ui->checkMCleanCache->isChecked()));
 Setting.insert(igOther,OtherKeys);

 applySettings(Setting);


 return Setting;
}
void Settings::loadSettings(const IniSettingMap &set)
{
 IniKeyMap key;
 QString value;
 QFont font;
 font.fromString(set.value(igMapView).value(ikStationFont));
 setFontToLabel(ui->labelSFont,font);

 // [MapView]
 key=set.value(igMapView);
 value=key.value(ikStationCustomFont);
 if(!value.isEmpty()) ui->checkSCustomFont->setChecked(value.toInt());
 value=key.value(ikStationBack);
 if(!value.isEmpty()) ui->checkSBackColor->setChecked(value.toInt());
 value=key.value(ikStationShadow);
 ui->checkSShadow->setChecked(value.toInt());
 value=key.value(ikSBackColor);
 if(!value.isEmpty())
 {
  SBackColor.setNamedColor(value);
  ui->bSBackColor->setStyleSheet(QString("background: %1").arg(value));
 }
 value=key.value(ikSShadowColor);
 if(!value.isEmpty())
 {
  SShadowColor.setNamedColor(value);
  ui->bSShadowColor->setStyleSheet(QString("background: %1").arg(value));
 }
 value=key.value(ikMBackColor);
 if(!value.isEmpty())
 {
  MBackColor.setNamedColor(value);
  ui->bMBackColor->setStyleSheet(QString("background: %1").arg(value));
 }
 value=key.value(ikSUpperCase);
 if(!value.isEmpty()) ui->checkSUpperCase->setChecked(value.toInt());
 value=key.value(ikSWordWrap);
 if(!value.isEmpty()) ui->checkSWordWrap->setChecked(value.toInt());
 value=key.value(ikSTransparency);
 if(!value.isEmpty()) ui->spinSTransparency->setValue(value.toInt());
 value=key.value(ikMShowScrollbar);
 if(!value.isEmpty()) ui->checkMShowScrollbar->setChecked(value.toInt());
 value=key.value(ikMShowTime);
 if(!value.isEmpty()) ui->checkMShowTime->setChecked(value.toInt());
 value=key.value(ikMShowBackground);
 if(!value.isEmpty()) ui->checkMShowBackground->setChecked(value.toInt());
 value=key.value(ikMAntialiasing);
 if(!value.isEmpty()) ui->checkMAntialiasing->setChecked(value.toInt());
 value=key.value(ikMFastScrolling);
 if(!value.isEmpty()) ui->checkMFastScrolling->setChecked(value.toInt());
 value=key.value(ikMSimpleTransfers);
 if(!value.isEmpty()) ui->checkMSimpleTransfers->setChecked(value.toInt());
 value=key.value(ikMCaching);
 if(!value.isEmpty()) ui->checkMCaching->setChecked(value.toInt());
 else ui->checkMCaching->setChecked(mainWnd->map->config.enableCaching);

 // [Main]
 key=set.value(igMain);
 value=key.value(ikWFullScreen);
 if(!value.isEmpty()) ui->checkWFullScreen->setChecked(value.toInt());
 value=key.value(ikWUiScale);
 if(!value.isEmpty()) ui->spinUiScale->setValue(value.toFloat()*100);

 // [Other]
 value=set.value(igOther).value(ikMCleanCache);
 if(!value.isEmpty()) ui->checkMCleanCache->setChecked(value.toInt());

 //set.value(igMapView).value().toInt()

}

void Settings::on_bMEmptyExit_clicked()
{
 removeDir(cachePath);
 updateLabelCacheSize();
}

void Settings::updateLabelCacheSize()
{
 qreal Size=sizeOfDir(cachePath)/1024;

 QString Ext="Kb";

 if(Size>1024) {Size=Size/1024; Ext="Mb";}
 if(Size>1024) {Size=Size/1024; Ext="Gb";}
 if(Size>1024) {Size=Size/1024; Ext="Tb";}

 ui->labelCacheSize->setText(QString("%1 %2").arg((Size-int(Size)>0 ? QString::number(Size,'f',2):QString::number(Size))).arg(Ext));
}
